<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetSatellitesAroundLocation
     * Meta informations extracted from the WSDL
     * - documentation: GetSatellitesAroundLocation is a method...
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $obsLatitude
     * @param string $obsLongitude
     * @param string $elevation
     * @param string $category
     * @param string $license
     * @return \StructType\Satellite[]|bool
     */
    public function GetSatellitesAroundLocation($obsLatitude, $obsLongitude, $elevation, $category, $license)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSatellitesAroundLocation($obsLatitude, $obsLongitude, $elevation, $category, $license));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVisiblePasses
     * Meta informations extracted from the WSDL
     * - documentation: GetVisiblePasses is a method...
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $id
     * @param string $lat
     * @param string $lng
     * @param string $alt
     * @param string $days
     * @param string $minduration
     * @param string $license
     * @return \StructType\Pass[]|bool
     */
    public function GetVisiblePasses($id, $lat, $lng, $alt, $days, $minduration, $license)
    {
        try {
            $this->setResult(self::getSoapClient()->GetVisiblePasses($id, $lat, $lng, $alt, $days, $minduration, $license));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllPasses
     * Meta informations extracted from the WSDL
     * - documentation: GetAllPasses is a method...
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $id
     * @param string $lat
     * @param string $lng
     * @param string $alt
     * @param string $days
     * @param string $minduration
     * @param string $minelevation
     * @param string $license
     * @return \StructType\Pass[]|bool
     */
    public function GetAllPasses($id, $lat, $lng, $alt, $days, $minduration, $minelevation, $license)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAllPasses($id, $lat, $lng, $alt, $days, $minduration, $minelevation, $license));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPositionsByAddress
     * Meta informations extracted from the WSDL
     * - documentation: GetPositionsByAddress is a method...
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $id
     * @param string $address
     * @param string $seconds
     * @param string $license
     * @return \StructType\SatellitePosition[]|bool
     */
    public function GetPositionsByAddress($id, $address, $seconds, $license)
    {
        try {
            $this->setResult(self::getSoapClient()->GetPositionsByAddress($id, $address, $seconds, $license));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPositionsByIp
     * Meta informations extracted from the WSDL
     * - documentation: GetPositionsByIp is a method...
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $id
     * @param string $ip
     * @param string $seconds
     * @param string $license
     * @return \StructType\SatellitePosition[]|bool
     */
    public function GetPositionsByIp($id, $ip, $seconds, $license)
    {
        try {
            $this->setResult(self::getSoapClient()->GetPositionsByIp($id, $ip, $seconds, $license));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPositionsByLatLng
     * Meta informations extracted from the WSDL
     * - documentation: GetPositionsByLatLng is a method...
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $id
     * @param string $lat
     * @param string $lng
     * @param string $seconds
     * @param string $license
     * @return \StructType\SatellitePosition[]|bool
     */
    public function GetPositionsByLatLng($id, $lat, $lng, $seconds, $license)
    {
        try {
            $this->setResult(self::getSoapClient()->GetPositionsByLatLng($id, $lat, $lng, $seconds, $license));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTLEs
     * Meta informations extracted from the WSDL
     * - documentation: GetTLEs is a method...
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $category
     * @param string $license
     * @return \StructType\SatelliteInfo[]|bool
     */
    public function GetTLEs($category, $license)
    {
        try {
            $this->setResult(self::getSoapClient()->GetTLEs($category, $license));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLocationByZip
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $zip
     * @param string $license
     * @return array|bool
     */
    public function GetLocationByZip($zip, $license)
    {
        try {
            $this->setResult(self::getSoapClient()->GetLocationByZip($zip, $license));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSatelliteName
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $id
     * @param string $license
     * @return array|bool
     */
    public function GetSatelliteName($id, $license)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSatelliteName($id, $license));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetGeoIp
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $ip
     * @param string $license
     * @return array|bool
     */
    public function GetGeoIp($ip, $license)
    {
        try {
            $this->setResult(self::getSoapClient()->GetGeoIp($ip, $license));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return array|\StructType\Pass[]|\StructType\SatelliteInfo[]|\StructType\SatellitePosition[]|\StructType\Satellite[]
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
