<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SatellitePosition StructType
 * @subpackage Structs
 */
class SatellitePosition extends AbstractStructBase
{
    /**
     * The id
     * @var int
     */
    public $id;
    /**
     * The shortname
     * @var string
     */
    public $shortname;
    /**
     * The satlatitude
     * @var float
     */
    public $satlatitude;
    /**
     * The satlongitude
     * @var float
     */
    public $satlongitude;
    /**
     * The sataltitude
     * @var float
     */
    public $sataltitude;
    /**
     * The azimuth
     * @var float
     */
    public $azimuth;
    /**
     * The elevation
     * @var float
     */
    public $elevation;
    /**
     * The ra
     * @var float
     */
    public $ra;
    /**
     * The dec
     * @var float
     */
    public $dec;
    /**
     * The city
     * @var string
     */
    public $city;
    /**
     * The region
     * @var string
     */
    public $region;
    /**
     * The countrycode
     * @var string
     */
    public $countrycode;
    /**
     * The country
     * @var string
     */
    public $country;
    /**
     * The homelatitude
     * @var float
     */
    public $homelatitude;
    /**
     * The homelongitude
     * @var float
     */
    public $homelongitude;
    /**
     * The timestamp
     * @var int
     */
    public $timestamp;
    /**
     * Constructor method for SatellitePosition
     * @uses SatellitePosition::setId()
     * @uses SatellitePosition::setShortname()
     * @uses SatellitePosition::setSatlatitude()
     * @uses SatellitePosition::setSatlongitude()
     * @uses SatellitePosition::setSataltitude()
     * @uses SatellitePosition::setAzimuth()
     * @uses SatellitePosition::setElevation()
     * @uses SatellitePosition::setRa()
     * @uses SatellitePosition::setDec()
     * @uses SatellitePosition::setCity()
     * @uses SatellitePosition::setRegion()
     * @uses SatellitePosition::setCountrycode()
     * @uses SatellitePosition::setCountry()
     * @uses SatellitePosition::setHomelatitude()
     * @uses SatellitePosition::setHomelongitude()
     * @uses SatellitePosition::setTimestamp()
     * @param int $id
     * @param string $shortname
     * @param float $satlatitude
     * @param float $satlongitude
     * @param float $sataltitude
     * @param float $azimuth
     * @param float $elevation
     * @param float $ra
     * @param float $dec
     * @param string $city
     * @param string $region
     * @param string $countrycode
     * @param string $country
     * @param float $homelatitude
     * @param float $homelongitude
     * @param int $timestamp
     */
    public function __construct($id = null, $shortname = null, $satlatitude = null, $satlongitude = null, $sataltitude = null, $azimuth = null, $elevation = null, $ra = null, $dec = null, $city = null, $region = null, $countrycode = null, $country = null, $homelatitude = null, $homelongitude = null, $timestamp = null)
    {
        $this
            ->setId($id)
            ->setShortname($shortname)
            ->setSatlatitude($satlatitude)
            ->setSatlongitude($satlongitude)
            ->setSataltitude($sataltitude)
            ->setAzimuth($azimuth)
            ->setElevation($elevation)
            ->setRa($ra)
            ->setDec($dec)
            ->setCity($city)
            ->setRegion($region)
            ->setCountrycode($countrycode)
            ->setCountry($country)
            ->setHomelatitude($homelatitude)
            ->setHomelongitude($homelongitude)
            ->setTimestamp($timestamp);
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\SatellitePosition
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get shortname value
     * @return string|null
     */
    public function getShortname()
    {
        return $this->shortname;
    }
    /**
     * Set shortname value
     * @param string $shortname
     * @return \StructType\SatellitePosition
     */
    public function setShortname($shortname = null)
    {
        // validation for constraint: string
        if (!is_null($shortname) && !is_string($shortname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shortname)), __LINE__);
        }
        $this->shortname = $shortname;
        return $this;
    }
    /**
     * Get satlatitude value
     * @return float|null
     */
    public function getSatlatitude()
    {
        return $this->satlatitude;
    }
    /**
     * Set satlatitude value
     * @param float $satlatitude
     * @return \StructType\SatellitePosition
     */
    public function setSatlatitude($satlatitude = null)
    {
        $this->satlatitude = $satlatitude;
        return $this;
    }
    /**
     * Get satlongitude value
     * @return float|null
     */
    public function getSatlongitude()
    {
        return $this->satlongitude;
    }
    /**
     * Set satlongitude value
     * @param float $satlongitude
     * @return \StructType\SatellitePosition
     */
    public function setSatlongitude($satlongitude = null)
    {
        $this->satlongitude = $satlongitude;
        return $this;
    }
    /**
     * Get sataltitude value
     * @return float|null
     */
    public function getSataltitude()
    {
        return $this->sataltitude;
    }
    /**
     * Set sataltitude value
     * @param float $sataltitude
     * @return \StructType\SatellitePosition
     */
    public function setSataltitude($sataltitude = null)
    {
        $this->sataltitude = $sataltitude;
        return $this;
    }
    /**
     * Get azimuth value
     * @return float|null
     */
    public function getAzimuth()
    {
        return $this->azimuth;
    }
    /**
     * Set azimuth value
     * @param float $azimuth
     * @return \StructType\SatellitePosition
     */
    public function setAzimuth($azimuth = null)
    {
        $this->azimuth = $azimuth;
        return $this;
    }
    /**
     * Get elevation value
     * @return float|null
     */
    public function getElevation()
    {
        return $this->elevation;
    }
    /**
     * Set elevation value
     * @param float $elevation
     * @return \StructType\SatellitePosition
     */
    public function setElevation($elevation = null)
    {
        $this->elevation = $elevation;
        return $this;
    }
    /**
     * Get ra value
     * @return float|null
     */
    public function getRa()
    {
        return $this->ra;
    }
    /**
     * Set ra value
     * @param float $ra
     * @return \StructType\SatellitePosition
     */
    public function setRa($ra = null)
    {
        $this->ra = $ra;
        return $this;
    }
    /**
     * Get dec value
     * @return float|null
     */
    public function getDec()
    {
        return $this->dec;
    }
    /**
     * Set dec value
     * @param float $dec
     * @return \StructType\SatellitePosition
     */
    public function setDec($dec = null)
    {
        $this->dec = $dec;
        return $this;
    }
    /**
     * Get city value
     * @return string|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \StructType\SatellitePosition
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get region value
     * @return string|null
     */
    public function getRegion()
    {
        return $this->region;
    }
    /**
     * Set region value
     * @param string $region
     * @return \StructType\SatellitePosition
     */
    public function setRegion($region = null)
    {
        // validation for constraint: string
        if (!is_null($region) && !is_string($region)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($region)), __LINE__);
        }
        $this->region = $region;
        return $this;
    }
    /**
     * Get countrycode value
     * @return string|null
     */
    public function getCountrycode()
    {
        return $this->countrycode;
    }
    /**
     * Set countrycode value
     * @param string $countrycode
     * @return \StructType\SatellitePosition
     */
    public function setCountrycode($countrycode = null)
    {
        // validation for constraint: string
        if (!is_null($countrycode) && !is_string($countrycode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($countrycode)), __LINE__);
        }
        $this->countrycode = $countrycode;
        return $this;
    }
    /**
     * Get country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \StructType\SatellitePosition
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get homelatitude value
     * @return float|null
     */
    public function getHomelatitude()
    {
        return $this->homelatitude;
    }
    /**
     * Set homelatitude value
     * @param float $homelatitude
     * @return \StructType\SatellitePosition
     */
    public function setHomelatitude($homelatitude = null)
    {
        $this->homelatitude = $homelatitude;
        return $this;
    }
    /**
     * Get homelongitude value
     * @return float|null
     */
    public function getHomelongitude()
    {
        return $this->homelongitude;
    }
    /**
     * Set homelongitude value
     * @param float $homelongitude
     * @return \StructType\SatellitePosition
     */
    public function setHomelongitude($homelongitude = null)
    {
        $this->homelongitude = $homelongitude;
        return $this;
    }
    /**
     * Get timestamp value
     * @return int|null
     */
    public function getTimestamp()
    {
        return $this->timestamp;
    }
    /**
     * Set timestamp value
     * @param int $timestamp
     * @return \StructType\SatellitePosition
     */
    public function setTimestamp($timestamp = null)
    {
        // validation for constraint: int
        if (!is_null($timestamp) && !is_numeric($timestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($timestamp)), __LINE__);
        }
        $this->timestamp = $timestamp;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SatellitePosition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
