<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VerzoekContext StructType
 * Meta informations extracted from the WSDL
 * - type: tns:VerzoekContext
 * @subpackage Structs
 */
class VerzoekContext extends AntwoordContext
{
    /**
     * The Organisatie
     * Meta informations extracted from the WSDL
     * - maxLength: 50
     * - minLength: 1
     * - type: tns:IdentificatieCode
     * @var string
     */
    public $Organisatie;
    /**
     * The Register
     * Meta informations extracted from the WSDL
     * - type: tns:SoortPersoonsRegister
     * @var string
     */
    public $Register;
    /**
     * The SoftwareVersie
     * @var \StructType\SoftwareVersie
     */
    public $SoftwareVersie;
    /**
     * Constructor method for VerzoekContext
     * @uses VerzoekContext::setOrganisatie()
     * @uses VerzoekContext::setRegister()
     * @uses VerzoekContext::setSoftwareVersie()
     * @param string $organisatie
     * @param string $register
     * @param \StructType\SoftwareVersie $softwareVersie
     */
    public function __construct($organisatie = null, $register = null, \StructType\SoftwareVersie $softwareVersie = null)
    {
        $this
            ->setOrganisatie($organisatie)
            ->setRegister($register)
            ->setSoftwareVersie($softwareVersie);
    }
    /**
     * Get Organisatie value
     * @return string|null
     */
    public function getOrganisatie()
    {
        return $this->Organisatie;
    }
    /**
     * Set Organisatie value
     * @param string $organisatie
     * @return \StructType\VerzoekContext
     */
    public function setOrganisatie($organisatie = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($organisatie) && strlen($organisatie) > 50) || (is_array($organisatie) && count($organisatie) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($organisatie) ? strlen($organisatie) : count($organisatie)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($organisatie) && strlen($organisatie) < 1) || (is_array($organisatie) && count($organisatie) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($organisatie) && !is_string($organisatie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($organisatie)), __LINE__);
        }
        $this->Organisatie = $organisatie;
        return $this;
    }
    /**
     * Get Register value
     * @return string|null
     */
    public function getRegister()
    {
        return $this->Register;
    }
    /**
     * Set Register value
     * @param string $register
     * @return \StructType\VerzoekContext
     */
    public function setRegister($register = null)
    {
        // validation for constraint: string
        if (!is_null($register) && !is_string($register)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($register)), __LINE__);
        }
        $this->Register = $register;
        return $this;
    }
    /**
     * Get SoftwareVersie value
     * @return \StructType\SoftwareVersie|null
     */
    public function getSoftwareVersie()
    {
        return $this->SoftwareVersie;
    }
    /**
     * Set SoftwareVersie value
     * @param \StructType\SoftwareVersie $softwareVersie
     * @return \StructType\VerzoekContext
     */
    public function setSoftwareVersie(\StructType\SoftwareVersie $softwareVersie = null)
    {
        $this->SoftwareVersie = $softwareVersie;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VerzoekContext
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
