<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValideerCertificaatAntwoord StructType
 * Meta informations extracted from the WSDL
 * - type: tns:ValideerCertificaatAntwoord
 * @subpackage Structs
 */
class ValideerCertificaatAntwoord extends Antwoord
{
    /**
     * The IndicatieProductieOmgeving
     * @var bool
     */
    public $IndicatieProductieOmgeving;
    /**
     * The IndicatieTestOmgeving
     * @var bool
     */
    public $IndicatieTestOmgeving;
    /**
     * The Meldingen
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Meldingen
     */
    public $Meldingen;
    /**
     * Constructor method for ValideerCertificaatAntwoord
     * @uses ValideerCertificaatAntwoord::setIndicatieProductieOmgeving()
     * @uses ValideerCertificaatAntwoord::setIndicatieTestOmgeving()
     * @uses ValideerCertificaatAntwoord::setMeldingen()
     * @param bool $indicatieProductieOmgeving
     * @param bool $indicatieTestOmgeving
     * @param \StructType\Meldingen $meldingen
     */
    public function __construct($indicatieProductieOmgeving = null, $indicatieTestOmgeving = null, \StructType\Meldingen $meldingen = null)
    {
        $this
            ->setIndicatieProductieOmgeving($indicatieProductieOmgeving)
            ->setIndicatieTestOmgeving($indicatieTestOmgeving)
            ->setMeldingen($meldingen);
    }
    /**
     * Get IndicatieProductieOmgeving value
     * @return bool|null
     */
    public function getIndicatieProductieOmgeving()
    {
        return $this->IndicatieProductieOmgeving;
    }
    /**
     * Set IndicatieProductieOmgeving value
     * @param bool $indicatieProductieOmgeving
     * @return \StructType\ValideerCertificaatAntwoord
     */
    public function setIndicatieProductieOmgeving($indicatieProductieOmgeving = null)
    {
        // validation for constraint: boolean
        if (!is_null($indicatieProductieOmgeving) && !is_bool($indicatieProductieOmgeving)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($indicatieProductieOmgeving)), __LINE__);
        }
        $this->IndicatieProductieOmgeving = $indicatieProductieOmgeving;
        return $this;
    }
    /**
     * Get IndicatieTestOmgeving value
     * @return bool|null
     */
    public function getIndicatieTestOmgeving()
    {
        return $this->IndicatieTestOmgeving;
    }
    /**
     * Set IndicatieTestOmgeving value
     * @param bool $indicatieTestOmgeving
     * @return \StructType\ValideerCertificaatAntwoord
     */
    public function setIndicatieTestOmgeving($indicatieTestOmgeving = null)
    {
        // validation for constraint: boolean
        if (!is_null($indicatieTestOmgeving) && !is_bool($indicatieTestOmgeving)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($indicatieTestOmgeving)), __LINE__);
        }
        $this->IndicatieTestOmgeving = $indicatieTestOmgeving;
        return $this;
    }
    /**
     * Get Meldingen value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Meldingen|null
     */
    public function getMeldingen()
    {
        return isset($this->Meldingen) ? $this->Meldingen : null;
    }
    /**
     * Set Meldingen value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Meldingen $meldingen
     * @return \StructType\ValideerCertificaatAntwoord
     */
    public function setMeldingen(\StructType\Meldingen $meldingen = null)
    {
        if (is_null($meldingen) || (is_array($meldingen) && empty($meldingen))) {
            unset($this->Meldingen);
        } else {
            $this->Meldingen = $meldingen;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ValideerCertificaatAntwoord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
