<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AntwoordContext StructType
 * Meta informations extracted from the WSDL
 * - type: tns:AntwoordContext
 * @subpackage Structs
 */
class AntwoordContext extends ExtensibleDataObject
{
    /**
     * The ExterneReferentie
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 50
     * - minLength: 1
     * - type: tns:String50
     * @var string
     */
    public $ExterneReferentie;
    /**
     * Constructor method for AntwoordContext
     * @uses AntwoordContext::setExterneReferentie()
     * @param string $externeReferentie
     */
    public function __construct($externeReferentie = null)
    {
        $this
            ->setExterneReferentie($externeReferentie);
    }
    /**
     * Get ExterneReferentie value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExterneReferentie()
    {
        return isset($this->ExterneReferentie) ? $this->ExterneReferentie : null;
    }
    /**
     * Set ExterneReferentie value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externeReferentie
     * @return \StructType\AntwoordContext
     */
    public function setExterneReferentie($externeReferentie = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($externeReferentie) && strlen($externeReferentie) > 50) || (is_array($externeReferentie) && count($externeReferentie) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($externeReferentie) ? strlen($externeReferentie) : count($externeReferentie)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($externeReferentie) && strlen($externeReferentie) < 1) || (is_array($externeReferentie) && count($externeReferentie) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($externeReferentie) && !is_string($externeReferentie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externeReferentie)), __LINE__);
        }
        if (is_null($externeReferentie) || (is_array($externeReferentie) && empty($externeReferentie))) {
            unset($this->ExterneReferentie);
        } else {
            $this->ExterneReferentie = $externeReferentie;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AntwoordContext
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
