<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Verwerkingsresultaat StructType
 * Meta informations extracted from the WSDL
 * - type: tns:Verwerkingsresultaat
 * @subpackage Structs
 */
class Verwerkingsresultaat extends ExtensibleDataObject
{
    /**
     * The IncidentCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 50
     * - minLength: 1
     * - type: tns:IdentificatieCode
     * @var string
     */
    public $IncidentCode;
    /**
     * The IndicatieCorrectVerwerkt
     * @var bool
     */
    public $IndicatieCorrectVerwerkt;
    /**
     * The Meldingen
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Meldingen
     */
    public $Meldingen;
    /**
     * Constructor method for Verwerkingsresultaat
     * @uses Verwerkingsresultaat::setIncidentCode()
     * @uses Verwerkingsresultaat::setIndicatieCorrectVerwerkt()
     * @uses Verwerkingsresultaat::setMeldingen()
     * @param string $incidentCode
     * @param bool $indicatieCorrectVerwerkt
     * @param \StructType\Meldingen $meldingen
     */
    public function __construct($incidentCode = null, $indicatieCorrectVerwerkt = null, \StructType\Meldingen $meldingen = null)
    {
        $this
            ->setIncidentCode($incidentCode)
            ->setIndicatieCorrectVerwerkt($indicatieCorrectVerwerkt)
            ->setMeldingen($meldingen);
    }
    /**
     * Get IncidentCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIncidentCode()
    {
        return isset($this->IncidentCode) ? $this->IncidentCode : null;
    }
    /**
     * Set IncidentCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $incidentCode
     * @return \StructType\Verwerkingsresultaat
     */
    public function setIncidentCode($incidentCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($incidentCode) && strlen($incidentCode) > 50) || (is_array($incidentCode) && count($incidentCode) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($incidentCode) ? strlen($incidentCode) : count($incidentCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($incidentCode) && strlen($incidentCode) < 1) || (is_array($incidentCode) && count($incidentCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($incidentCode) && !is_string($incidentCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($incidentCode)), __LINE__);
        }
        if (is_null($incidentCode) || (is_array($incidentCode) && empty($incidentCode))) {
            unset($this->IncidentCode);
        } else {
            $this->IncidentCode = $incidentCode;
        }
        return $this;
    }
    /**
     * Get IndicatieCorrectVerwerkt value
     * @return bool|null
     */
    public function getIndicatieCorrectVerwerkt()
    {
        return $this->IndicatieCorrectVerwerkt;
    }
    /**
     * Set IndicatieCorrectVerwerkt value
     * @param bool $indicatieCorrectVerwerkt
     * @return \StructType\Verwerkingsresultaat
     */
    public function setIndicatieCorrectVerwerkt($indicatieCorrectVerwerkt = null)
    {
        // validation for constraint: boolean
        if (!is_null($indicatieCorrectVerwerkt) && !is_bool($indicatieCorrectVerwerkt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($indicatieCorrectVerwerkt)), __LINE__);
        }
        $this->IndicatieCorrectVerwerkt = $indicatieCorrectVerwerkt;
        return $this;
    }
    /**
     * Get Meldingen value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Meldingen|null
     */
    public function getMeldingen()
    {
        return isset($this->Meldingen) ? $this->Meldingen : null;
    }
    /**
     * Set Meldingen value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Meldingen $meldingen
     * @return \StructType\Verwerkingsresultaat
     */
    public function setMeldingen(\StructType\Meldingen $meldingen = null)
    {
        if (is_null($meldingen) || (is_array($meldingen) && empty($meldingen))) {
            unset($this->Meldingen);
        } else {
            $this->Meldingen = $meldingen;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Verwerkingsresultaat
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
