<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SoftwareVersie StructType
 * Meta informations extracted from the WSDL
 * - type: tns:SoftwareVersie
 * @subpackage Structs
 */
class SoftwareVersie extends ExtensibleDataObject
{
    /**
     * The Leverancier
     * Meta informations extracted from the WSDL
     * - maxLength: 80
     * - minLength: 1
     * - type: tns:String80
     * @var string
     */
    public $Leverancier;
    /**
     * The Pakketnaam
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 50
     * - minLength: 1
     * - type: tns:String50
     * @var string
     */
    public $Pakketnaam;
    /**
     * The Versie
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 24
     * - minLength: 1
     * - type: tns:String24
     * @var string
     */
    public $Versie;
    /**
     * Constructor method for SoftwareVersie
     * @uses SoftwareVersie::setLeverancier()
     * @uses SoftwareVersie::setPakketnaam()
     * @uses SoftwareVersie::setVersie()
     * @param string $leverancier
     * @param string $pakketnaam
     * @param string $versie
     */
    public function __construct($leverancier = null, $pakketnaam = null, $versie = null)
    {
        $this
            ->setLeverancier($leverancier)
            ->setPakketnaam($pakketnaam)
            ->setVersie($versie);
    }
    /**
     * Get Leverancier value
     * @return string|null
     */
    public function getLeverancier()
    {
        return $this->Leverancier;
    }
    /**
     * Set Leverancier value
     * @param string $leverancier
     * @return \StructType\SoftwareVersie
     */
    public function setLeverancier($leverancier = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($leverancier) && strlen($leverancier) > 80) || (is_array($leverancier) && count($leverancier) > 80)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 80 element(s) or a scalar of 80 character(s) at most, "%d" length given', is_scalar($leverancier) ? strlen($leverancier) : count($leverancier)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($leverancier) && strlen($leverancier) < 1) || (is_array($leverancier) && count($leverancier) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($leverancier) && !is_string($leverancier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($leverancier)), __LINE__);
        }
        $this->Leverancier = $leverancier;
        return $this;
    }
    /**
     * Get Pakketnaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPakketnaam()
    {
        return isset($this->Pakketnaam) ? $this->Pakketnaam : null;
    }
    /**
     * Set Pakketnaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pakketnaam
     * @return \StructType\SoftwareVersie
     */
    public function setPakketnaam($pakketnaam = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($pakketnaam) && strlen($pakketnaam) > 50) || (is_array($pakketnaam) && count($pakketnaam) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($pakketnaam) ? strlen($pakketnaam) : count($pakketnaam)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($pakketnaam) && strlen($pakketnaam) < 1) || (is_array($pakketnaam) && count($pakketnaam) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pakketnaam) && !is_string($pakketnaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pakketnaam)), __LINE__);
        }
        if (is_null($pakketnaam) || (is_array($pakketnaam) && empty($pakketnaam))) {
            unset($this->Pakketnaam);
        } else {
            $this->Pakketnaam = $pakketnaam;
        }
        return $this;
    }
    /**
     * Get Versie value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVersie()
    {
        return isset($this->Versie) ? $this->Versie : null;
    }
    /**
     * Set Versie value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $versie
     * @return \StructType\SoftwareVersie
     */
    public function setVersie($versie = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($versie) && strlen($versie) > 24) || (is_array($versie) && count($versie) > 24)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 24 element(s) or a scalar of 24 character(s) at most, "%d" length given', is_scalar($versie) ? strlen($versie) : count($versie)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($versie) && strlen($versie) < 1) || (is_array($versie) && count($versie) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($versie) && !is_string($versie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($versie)), __LINE__);
        }
        if (is_null($versie) || (is_array($versie) && empty($versie))) {
            unset($this->Versie);
        } else {
            $this->Versie = $versie;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SoftwareVersie
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
