<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ObjectMelding StructType
 * Meta informations extracted from the WSDL
 * - type: tns:ObjectMelding
 * @subpackage Structs
 */
class ObjectMelding extends Melding
{
    /**
     * The Identificatie
     * Meta informations extracted from the WSDL
     * - maxLength: 50
     * - minLength: 1
     * - type: tns:IdentificatieCode
     * @var string
     */
    public $Identificatie;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - type: tns:SoortObject
     * @var string
     */
    public $Type;
    /**
     * Constructor method for ObjectMelding
     * @uses ObjectMelding::setIdentificatie()
     * @uses ObjectMelding::setType()
     * @param string $identificatie
     * @param string $type
     */
    public function __construct($identificatie = null, $type = null)
    {
        $this
            ->setIdentificatie($identificatie)
            ->setType($type);
    }
    /**
     * Get Identificatie value
     * @return string|null
     */
    public function getIdentificatie()
    {
        return $this->Identificatie;
    }
    /**
     * Set Identificatie value
     * @param string $identificatie
     * @return \StructType\ObjectMelding
     */
    public function setIdentificatie($identificatie = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($identificatie) && strlen($identificatie) > 50) || (is_array($identificatie) && count($identificatie) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($identificatie) ? strlen($identificatie) : count($identificatie)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($identificatie) && strlen($identificatie) < 1) || (is_array($identificatie) && count($identificatie) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($identificatie) && !is_string($identificatie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($identificatie)), __LINE__);
        }
        $this->Identificatie = $identificatie;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\ObjectMelding
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ObjectMelding
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
