<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Meldingen StructType
 * Meta informations extracted from the WSDL
 * - type: tns:Meldingen
 * @subpackage Structs
 */
class Meldingen extends AbstractStructBase
{
    /**
     * The Melding
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Melding[]
     */
    public $Melding;
    /**
     * Constructor method for Meldingen
     * @uses Meldingen::setMelding()
     * @param \StructType\Melding[] $melding
     */
    public function __construct(array $melding = array())
    {
        $this
            ->setMelding($melding);
    }
    /**
     * Get Melding value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Melding[]|null
     */
    public function getMelding()
    {
        return isset($this->Melding) ? $this->Melding : null;
    }
    /**
     * Set Melding value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Melding[] $melding
     * @return \StructType\Meldingen
     */
    public function setMelding(array $melding = array())
    {
        foreach ($melding as $meldingenMeldingItem) {
            // validation for constraint: itemType
            if (!$meldingenMeldingItem instanceof \StructType\Melding) {
                throw new \InvalidArgumentException(sprintf('The Melding property can only contain items of \StructType\Melding, "%s" given', is_object($meldingenMeldingItem) ? get_class($meldingenMeldingItem) : gettype($meldingenMeldingItem)), __LINE__);
            }
        }
        if (is_null($melding) || (is_array($melding) && empty($melding))) {
            unset($this->Melding);
        } else {
            $this->Melding = $melding;
        }
        return $this;
    }
    /**
     * Add item to Melding value
     * @throws \InvalidArgumentException
     * @param \StructType\Melding $item
     * @return \StructType\Meldingen
     */
    public function addToMelding(\StructType\Melding $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Melding) {
            throw new \InvalidArgumentException(sprintf('The Melding property can only contain items of \StructType\Melding, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Melding[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Meldingen
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
