<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Melding StructType
 * Meta informations extracted from the WSDL
 * - type: tns:Melding
 * @subpackage Structs
 */
class Melding extends ExtensibleDataObject
{
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - type: tns:MeldingCode
     * @var string
     */
    public $Code;
    /**
     * The Omschrijving
     * @var string
     */
    public $Omschrijving;
    /**
     * Constructor method for Melding
     * @uses Melding::setCode()
     * @uses Melding::setOmschrijving()
     * @param string $code
     * @param string $omschrijving
     */
    public function __construct($code = null, $omschrijving = null)
    {
        $this
            ->setCode($code)
            ->setOmschrijving($omschrijving);
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\Melding
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Omschrijving value
     * @return string|null
     */
    public function getOmschrijving()
    {
        return $this->Omschrijving;
    }
    /**
     * Set Omschrijving value
     * @param string $omschrijving
     * @return \StructType\Melding
     */
    public function setOmschrijving($omschrijving = null)
    {
        // validation for constraint: string
        if (!is_null($omschrijving) && !is_string($omschrijving)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($omschrijving)), __LINE__);
        }
        $this->Omschrijving = $omschrijving;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Melding
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
