<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Antwoord StructType
 * Meta informations extracted from the WSDL
 * - type: tns:Antwoord
 * @subpackage Structs
 */
class Antwoord extends ExtensibleDataObject
{
    /**
     * The OperatieContext
     * @var \StructType\AntwoordContext
     */
    public $OperatieContext;
    /**
     * The Verwerkingsresultaat
     * @var \StructType\Verwerkingsresultaat
     */
    public $Verwerkingsresultaat;
    /**
     * Constructor method for Antwoord
     * @uses Antwoord::setOperatieContext()
     * @uses Antwoord::setVerwerkingsresultaat()
     * @param \StructType\AntwoordContext $operatieContext
     * @param \StructType\Verwerkingsresultaat $verwerkingsresultaat
     */
    public function __construct(\StructType\AntwoordContext $operatieContext = null, \StructType\Verwerkingsresultaat $verwerkingsresultaat = null)
    {
        $this
            ->setOperatieContext($operatieContext)
            ->setVerwerkingsresultaat($verwerkingsresultaat);
    }
    /**
     * Get OperatieContext value
     * @return \StructType\AntwoordContext|null
     */
    public function getOperatieContext()
    {
        return $this->OperatieContext;
    }
    /**
     * Set OperatieContext value
     * @param \StructType\AntwoordContext $operatieContext
     * @return \StructType\Antwoord
     */
    public function setOperatieContext(\StructType\AntwoordContext $operatieContext = null)
    {
        $this->OperatieContext = $operatieContext;
        return $this;
    }
    /**
     * Get Verwerkingsresultaat value
     * @return \StructType\Verwerkingsresultaat|null
     */
    public function getVerwerkingsresultaat()
    {
        return $this->Verwerkingsresultaat;
    }
    /**
     * Set Verwerkingsresultaat value
     * @param \StructType\Verwerkingsresultaat $verwerkingsresultaat
     * @return \StructType\Antwoord
     */
    public function setVerwerkingsresultaat(\StructType\Verwerkingsresultaat $verwerkingsresultaat = null)
    {
        $this->Verwerkingsresultaat = $verwerkingsresultaat;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Antwoord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
