<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://onesite.realpage.com/WebServices/CrossFire/AvailabilityAndPricing/Unit.asmx?WSDL',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://onesite.realpage.com/WebServices/CrossFire/AvailabilityAndPricing/Unit.asmx?WSDL',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for List ServiceType
 */
$list = new \ServiceType\_List($options);
$list->setSoapHeaderUserAuthInfo(new \StructType\UserAuthInfo());
/**
 * Sample call for _List operation/method
 */
if ($list->_List(new \StructType\_List()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
$get->setSoapHeaderUserAuthInfo(new \StructType\UserAuthInfo());
/**
 * Sample call for GetRentMatrix operation/method
 */
if ($get->GetRentMatrix(new \StructType\GetRentMatrix()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetFloorPlanGroupsByProperty operation/method
 */
if ($get->GetFloorPlanGroupsByProperty(new \StructType\GetFloorPlanGroupsByProperty()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetFloorPlanIDAndName operation/method
 */
if ($get->GetFloorPlanIDAndName(new \StructType\GetFloorPlanIDAndName()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetUnitsByProperty operation/method
 */
if ($get->GetUnitsByProperty(new \StructType\GetUnitsByProperty()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
