<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnitObject StructType
 * @subpackage Structs
 */
class UnitObject extends AbstractStructBase
{
    /**
     * The PropertyNumberID
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PropertyNumberID;
    /**
     * The BaseRentAmount
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $BaseRentAmount;
    /**
     * The FloorPlanMarketRent
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $FloorPlanMarketRent;
    /**
     * The UnitMarketRent
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $UnitMarketRent;
    /**
     * The NonRevenueFlag
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $NonRevenueFlag;
    /**
     * The NonRefundFee
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $NonRefundFee;
    /**
     * The DepositAmount
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $DepositAmount;
    /**
     * The NonRevenueDescription
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NonRevenueDescription;
    /**
     * The Accessibility
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Accessibility
     */
    public $Accessibility;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Address
     */
    public $Address;
    /**
     * The Availability
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Availability
     */
    public $Availability;
    /**
     * The FloorPlan
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\FloorPlan
     */
    public $FloorPlan;
    /**
     * The UnitDetails
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\UnitDetails
     */
    public $UnitDetails;
    /**
     * The rentMatrix
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RentMatrix
     */
    public $rentMatrix;
    /**
     * Constructor method for UnitObject
     * @uses UnitObject::setPropertyNumberID()
     * @uses UnitObject::setBaseRentAmount()
     * @uses UnitObject::setFloorPlanMarketRent()
     * @uses UnitObject::setUnitMarketRent()
     * @uses UnitObject::setNonRevenueFlag()
     * @uses UnitObject::setNonRefundFee()
     * @uses UnitObject::setDepositAmount()
     * @uses UnitObject::setNonRevenueDescription()
     * @uses UnitObject::setAccessibility()
     * @uses UnitObject::setAddress()
     * @uses UnitObject::setAvailability()
     * @uses UnitObject::setFloorPlan()
     * @uses UnitObject::setUnitDetails()
     * @uses UnitObject::setRentMatrix()
     * @param int $propertyNumberID
     * @param float $baseRentAmount
     * @param float $floorPlanMarketRent
     * @param float $unitMarketRent
     * @param string $nonRevenueFlag
     * @param float $nonRefundFee
     * @param float $depositAmount
     * @param string $nonRevenueDescription
     * @param \StructType\Accessibility $accessibility
     * @param \StructType\Address $address
     * @param \StructType\Availability $availability
     * @param \StructType\FloorPlan $floorPlan
     * @param \StructType\UnitDetails $unitDetails
     * @param \StructType\RentMatrix $rentMatrix
     */
    public function __construct($propertyNumberID = null, $baseRentAmount = null, $floorPlanMarketRent = null, $unitMarketRent = null, $nonRevenueFlag = null, $nonRefundFee = null, $depositAmount = null, $nonRevenueDescription = null, \StructType\Accessibility $accessibility = null, \StructType\Address $address = null, \StructType\Availability $availability = null, \StructType\FloorPlan $floorPlan = null, \StructType\UnitDetails $unitDetails = null, \StructType\RentMatrix $rentMatrix = null)
    {
        $this
            ->setPropertyNumberID($propertyNumberID)
            ->setBaseRentAmount($baseRentAmount)
            ->setFloorPlanMarketRent($floorPlanMarketRent)
            ->setUnitMarketRent($unitMarketRent)
            ->setNonRevenueFlag($nonRevenueFlag)
            ->setNonRefundFee($nonRefundFee)
            ->setDepositAmount($depositAmount)
            ->setNonRevenueDescription($nonRevenueDescription)
            ->setAccessibility($accessibility)
            ->setAddress($address)
            ->setAvailability($availability)
            ->setFloorPlan($floorPlan)
            ->setUnitDetails($unitDetails)
            ->setRentMatrix($rentMatrix);
    }
    /**
     * Get PropertyNumberID value
     * @return int
     */
    public function getPropertyNumberID()
    {
        return $this->PropertyNumberID;
    }
    /**
     * Set PropertyNumberID value
     * @param int $propertyNumberID
     * @return \StructType\UnitObject
     */
    public function setPropertyNumberID($propertyNumberID = null)
    {
        // validation for constraint: int
        if (!is_null($propertyNumberID) && !is_numeric($propertyNumberID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($propertyNumberID)), __LINE__);
        }
        $this->PropertyNumberID = $propertyNumberID;
        return $this;
    }
    /**
     * Get BaseRentAmount value
     * @return float
     */
    public function getBaseRentAmount()
    {
        return $this->BaseRentAmount;
    }
    /**
     * Set BaseRentAmount value
     * @param float $baseRentAmount
     * @return \StructType\UnitObject
     */
    public function setBaseRentAmount($baseRentAmount = null)
    {
        $this->BaseRentAmount = $baseRentAmount;
        return $this;
    }
    /**
     * Get FloorPlanMarketRent value
     * @return float
     */
    public function getFloorPlanMarketRent()
    {
        return $this->FloorPlanMarketRent;
    }
    /**
     * Set FloorPlanMarketRent value
     * @param float $floorPlanMarketRent
     * @return \StructType\UnitObject
     */
    public function setFloorPlanMarketRent($floorPlanMarketRent = null)
    {
        $this->FloorPlanMarketRent = $floorPlanMarketRent;
        return $this;
    }
    /**
     * Get UnitMarketRent value
     * @return float
     */
    public function getUnitMarketRent()
    {
        return $this->UnitMarketRent;
    }
    /**
     * Set UnitMarketRent value
     * @param float $unitMarketRent
     * @return \StructType\UnitObject
     */
    public function setUnitMarketRent($unitMarketRent = null)
    {
        $this->UnitMarketRent = $unitMarketRent;
        return $this;
    }
    /**
     * Get NonRevenueFlag value
     * @return string
     */
    public function getNonRevenueFlag()
    {
        return $this->NonRevenueFlag;
    }
    /**
     * Set NonRevenueFlag value
     * @param string $nonRevenueFlag
     * @return \StructType\UnitObject
     */
    public function setNonRevenueFlag($nonRevenueFlag = null)
    {
        // validation for constraint: string
        if (!is_null($nonRevenueFlag) && !is_string($nonRevenueFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nonRevenueFlag)), __LINE__);
        }
        $this->NonRevenueFlag = $nonRevenueFlag;
        return $this;
    }
    /**
     * Get NonRefundFee value
     * @return float
     */
    public function getNonRefundFee()
    {
        return $this->NonRefundFee;
    }
    /**
     * Set NonRefundFee value
     * @param float $nonRefundFee
     * @return \StructType\UnitObject
     */
    public function setNonRefundFee($nonRefundFee = null)
    {
        $this->NonRefundFee = $nonRefundFee;
        return $this;
    }
    /**
     * Get DepositAmount value
     * @return float
     */
    public function getDepositAmount()
    {
        return $this->DepositAmount;
    }
    /**
     * Set DepositAmount value
     * @param float $depositAmount
     * @return \StructType\UnitObject
     */
    public function setDepositAmount($depositAmount = null)
    {
        $this->DepositAmount = $depositAmount;
        return $this;
    }
    /**
     * Get NonRevenueDescription value
     * @return string|null
     */
    public function getNonRevenueDescription()
    {
        return $this->NonRevenueDescription;
    }
    /**
     * Set NonRevenueDescription value
     * @param string $nonRevenueDescription
     * @return \StructType\UnitObject
     */
    public function setNonRevenueDescription($nonRevenueDescription = null)
    {
        // validation for constraint: string
        if (!is_null($nonRevenueDescription) && !is_string($nonRevenueDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nonRevenueDescription)), __LINE__);
        }
        $this->NonRevenueDescription = $nonRevenueDescription;
        return $this;
    }
    /**
     * Get Accessibility value
     * @return \StructType\Accessibility|null
     */
    public function getAccessibility()
    {
        return $this->Accessibility;
    }
    /**
     * Set Accessibility value
     * @param \StructType\Accessibility $accessibility
     * @return \StructType\UnitObject
     */
    public function setAccessibility(\StructType\Accessibility $accessibility = null)
    {
        $this->Accessibility = $accessibility;
        return $this;
    }
    /**
     * Get Address value
     * @return \StructType\Address|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \StructType\Address $address
     * @return \StructType\UnitObject
     */
    public function setAddress(\StructType\Address $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get Availability value
     * @return \StructType\Availability|null
     */
    public function getAvailability()
    {
        return $this->Availability;
    }
    /**
     * Set Availability value
     * @param \StructType\Availability $availability
     * @return \StructType\UnitObject
     */
    public function setAvailability(\StructType\Availability $availability = null)
    {
        $this->Availability = $availability;
        return $this;
    }
    /**
     * Get FloorPlan value
     * @return \StructType\FloorPlan|null
     */
    public function getFloorPlan()
    {
        return $this->FloorPlan;
    }
    /**
     * Set FloorPlan value
     * @param \StructType\FloorPlan $floorPlan
     * @return \StructType\UnitObject
     */
    public function setFloorPlan(\StructType\FloorPlan $floorPlan = null)
    {
        $this->FloorPlan = $floorPlan;
        return $this;
    }
    /**
     * Get UnitDetails value
     * @return \StructType\UnitDetails|null
     */
    public function getUnitDetails()
    {
        return $this->UnitDetails;
    }
    /**
     * Set UnitDetails value
     * @param \StructType\UnitDetails $unitDetails
     * @return \StructType\UnitObject
     */
    public function setUnitDetails(\StructType\UnitDetails $unitDetails = null)
    {
        $this->UnitDetails = $unitDetails;
        return $this;
    }
    /**
     * Get rentMatrix value
     * @return \StructType\RentMatrix|null
     */
    public function getRentMatrix()
    {
        return $this->rentMatrix;
    }
    /**
     * Set rentMatrix value
     * @param \StructType\RentMatrix $rentMatrix
     * @return \StructType\UnitObject
     */
    public function setRentMatrix(\StructType\RentMatrix $rentMatrix = null)
    {
        $this->rentMatrix = $rentMatrix;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UnitObject
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
