<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RentMatrix StructType
 * @subpackage Structs
 */
class RentMatrix_1 extends AbstractStructBase
{
    /**
     * The row
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Row[]
     */
    public $row;
    /**
     * The LeaseTerm
     * @var string
     */
    public $LeaseTerm;
    /**
     * The LeaseTermMax
     * @var string
     */
    public $LeaseTermMax;
    /**
     * The LeaseTermMin
     * @var string
     */
    public $LeaseTermMin;
    /**
     * The NeededByDate
     * @var string
     */
    public $NeededByDate;
    /**
     * The PropertyID
     * @var string
     */
    public $PropertyID;
    /**
     * Constructor method for RentMatrix
     * @uses RentMatrix_1::setRow_1()
     * @uses RentMatrix_1::setLeaseTerm_1()
     * @uses RentMatrix_1::setLeaseTermMax_1()
     * @uses RentMatrix_1::setLeaseTermMin_1()
     * @uses RentMatrix_1::setNeededByDate_1()
     * @uses RentMatrix_1::setPropertyID_1()
     * @param \StructType\Row[] $row
     * @param string $leaseTerm
     * @param string $leaseTermMax
     * @param string $leaseTermMin
     * @param string $neededByDate
     * @param string $propertyID
     */
    public function __construct(array $row = array(), $leaseTerm = null, $leaseTermMax = null, $leaseTermMin = null, $neededByDate = null, $propertyID = null)
    {
        $this
            ->setRow_1($row)
            ->setLeaseTerm_1($leaseTerm)
            ->setLeaseTermMax_1($leaseTermMax)
            ->setLeaseTermMin_1($leaseTermMin)
            ->setNeededByDate_1($neededByDate)
            ->setPropertyID_1($propertyID);
    }
    /**
     * Get row_1 value
     * @return row_1
     */
    public function getRow_1()
    {
        return $this->row;
    }
    /**
     * Set row value
     * @throws \InvalidArgumentException
     * @param \StructType\Row[] $row
     * @return \StructType\RentMatrix_1
     */
    public function setRow_1(array $row = array())
    {
        foreach ($row as $rentMatrixRowItem) {
            // validation for constraint: itemType
            if (!$rentMatrixRowItem instanceof \StructType\Row) {
                throw new \InvalidArgumentException(sprintf('The row property can only contain items of \StructType\Row, "%s" given', is_object($rentMatrixRowItem) ? get_class($rentMatrixRowItem) : gettype($rentMatrixRowItem)), __LINE__);
            }
        }
        $this->row = $row;
        return $this;
    }
    /**
     * Add item to row value
     * @throws \InvalidArgumentException
     * @param \StructType\Row $item
     * @return \StructType\RentMatrix_1
     */
    public function addToRow(\StructType\Row $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Row) {
            throw new \InvalidArgumentException(sprintf('The row property can only contain items of \StructType\Row, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->row[] = $item;
        return $this;
    }
    /**
     * Get leaseTerm_1 value
     * @return leaseTerm_1
     */
    public function getLeaseTerm_1()
    {
        return $this->LeaseTerm;
    }
    /**
     * Set LeaseTerm value
     * @param string $leaseTerm
     * @return \StructType\RentMatrix_1
     */
    public function setLeaseTerm_1($leaseTerm = null)
    {
        // validation for constraint: string
        if (!is_null($leaseTerm) && !is_string($leaseTerm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($leaseTerm)), __LINE__);
        }
        $this->LeaseTerm = $leaseTerm;
        return $this;
    }
    /**
     * Get leaseTermMax_1 value
     * @return leaseTermMax_1
     */
    public function getLeaseTermMax_1()
    {
        return $this->LeaseTermMax;
    }
    /**
     * Set LeaseTermMax value
     * @param string $leaseTermMax
     * @return \StructType\RentMatrix_1
     */
    public function setLeaseTermMax_1($leaseTermMax = null)
    {
        // validation for constraint: string
        if (!is_null($leaseTermMax) && !is_string($leaseTermMax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($leaseTermMax)), __LINE__);
        }
        $this->LeaseTermMax = $leaseTermMax;
        return $this;
    }
    /**
     * Get leaseTermMin_1 value
     * @return leaseTermMin_1
     */
    public function getLeaseTermMin_1()
    {
        return $this->LeaseTermMin;
    }
    /**
     * Set LeaseTermMin value
     * @param string $leaseTermMin
     * @return \StructType\RentMatrix_1
     */
    public function setLeaseTermMin_1($leaseTermMin = null)
    {
        // validation for constraint: string
        if (!is_null($leaseTermMin) && !is_string($leaseTermMin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($leaseTermMin)), __LINE__);
        }
        $this->LeaseTermMin = $leaseTermMin;
        return $this;
    }
    /**
     * Get neededByDate_1 value
     * @return neededByDate_1
     */
    public function getNeededByDate_1()
    {
        return $this->NeededByDate;
    }
    /**
     * Set NeededByDate value
     * @param string $neededByDate
     * @return \StructType\RentMatrix_1
     */
    public function setNeededByDate_1($neededByDate = null)
    {
        // validation for constraint: string
        if (!is_null($neededByDate) && !is_string($neededByDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($neededByDate)), __LINE__);
        }
        $this->NeededByDate = $neededByDate;
        return $this;
    }
    /**
     * Get propertyID_1 value
     * @return propertyID_1
     */
    public function getPropertyID_1()
    {
        return $this->PropertyID;
    }
    /**
     * Set PropertyID value
     * @param string $propertyID
     * @return \StructType\RentMatrix_1
     */
    public function setPropertyID_1($propertyID = null)
    {
        // validation for constraint: string
        if (!is_null($propertyID) && !is_string($propertyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($propertyID)), __LINE__);
        }
        $this->PropertyID = $propertyID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RentMatrix_1
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
