<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Availability StructType
 * @subpackage Structs
 */
class Availability extends AbstractStructBase
{
    /**
     * The MadeReadyBit
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $MadeReadyBit;
    /**
     * The AvailableBit
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $AvailableBit;
    /**
     * The VacantBit
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $VacantBit;
    /**
     * The UnavailableCode
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UnavailableCode;
    /**
     * The MadeReadyDate
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MadeReadyDate;
    /**
     * The AvailableDate
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AvailableDate;
    /**
     * The LastActionCode
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastActionCode;
    /**
     * The LastActionDesc
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastActionDesc;
    /**
     * The VacantDate
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VacantDate;
    /**
     * Constructor method for Availability
     * @uses Availability::setMadeReadyBit()
     * @uses Availability::setAvailableBit()
     * @uses Availability::setVacantBit()
     * @uses Availability::setUnavailableCode()
     * @uses Availability::setMadeReadyDate()
     * @uses Availability::setAvailableDate()
     * @uses Availability::setLastActionCode()
     * @uses Availability::setLastActionDesc()
     * @uses Availability::setVacantDate()
     * @param bool $madeReadyBit
     * @param bool $availableBit
     * @param bool $vacantBit
     * @param string $unavailableCode
     * @param string $madeReadyDate
     * @param string $availableDate
     * @param string $lastActionCode
     * @param string $lastActionDesc
     * @param string $vacantDate
     */
    public function __construct($madeReadyBit = null, $availableBit = null, $vacantBit = null, $unavailableCode = null, $madeReadyDate = null, $availableDate = null, $lastActionCode = null, $lastActionDesc = null, $vacantDate = null)
    {
        $this
            ->setMadeReadyBit($madeReadyBit)
            ->setAvailableBit($availableBit)
            ->setVacantBit($vacantBit)
            ->setUnavailableCode($unavailableCode)
            ->setMadeReadyDate($madeReadyDate)
            ->setAvailableDate($availableDate)
            ->setLastActionCode($lastActionCode)
            ->setLastActionDesc($lastActionDesc)
            ->setVacantDate($vacantDate);
    }
    /**
     * Get MadeReadyBit value
     * @return bool
     */
    public function getMadeReadyBit()
    {
        return $this->MadeReadyBit;
    }
    /**
     * Set MadeReadyBit value
     * @param bool $madeReadyBit
     * @return \StructType\Availability
     */
    public function setMadeReadyBit($madeReadyBit = null)
    {
        // validation for constraint: boolean
        if (!is_null($madeReadyBit) && !is_bool($madeReadyBit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($madeReadyBit)), __LINE__);
        }
        $this->MadeReadyBit = $madeReadyBit;
        return $this;
    }
    /**
     * Get AvailableBit value
     * @return bool
     */
    public function getAvailableBit()
    {
        return $this->AvailableBit;
    }
    /**
     * Set AvailableBit value
     * @param bool $availableBit
     * @return \StructType\Availability
     */
    public function setAvailableBit($availableBit = null)
    {
        // validation for constraint: boolean
        if (!is_null($availableBit) && !is_bool($availableBit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($availableBit)), __LINE__);
        }
        $this->AvailableBit = $availableBit;
        return $this;
    }
    /**
     * Get VacantBit value
     * @return bool
     */
    public function getVacantBit()
    {
        return $this->VacantBit;
    }
    /**
     * Set VacantBit value
     * @param bool $vacantBit
     * @return \StructType\Availability
     */
    public function setVacantBit($vacantBit = null)
    {
        // validation for constraint: boolean
        if (!is_null($vacantBit) && !is_bool($vacantBit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($vacantBit)), __LINE__);
        }
        $this->VacantBit = $vacantBit;
        return $this;
    }
    /**
     * Get UnavailableCode value
     * @return string|null
     */
    public function getUnavailableCode()
    {
        return $this->UnavailableCode;
    }
    /**
     * Set UnavailableCode value
     * @param string $unavailableCode
     * @return \StructType\Availability
     */
    public function setUnavailableCode($unavailableCode = null)
    {
        // validation for constraint: string
        if (!is_null($unavailableCode) && !is_string($unavailableCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unavailableCode)), __LINE__);
        }
        $this->UnavailableCode = $unavailableCode;
        return $this;
    }
    /**
     * Get MadeReadyDate value
     * @return string|null
     */
    public function getMadeReadyDate()
    {
        return $this->MadeReadyDate;
    }
    /**
     * Set MadeReadyDate value
     * @param string $madeReadyDate
     * @return \StructType\Availability
     */
    public function setMadeReadyDate($madeReadyDate = null)
    {
        // validation for constraint: string
        if (!is_null($madeReadyDate) && !is_string($madeReadyDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($madeReadyDate)), __LINE__);
        }
        $this->MadeReadyDate = $madeReadyDate;
        return $this;
    }
    /**
     * Get AvailableDate value
     * @return string|null
     */
    public function getAvailableDate()
    {
        return $this->AvailableDate;
    }
    /**
     * Set AvailableDate value
     * @param string $availableDate
     * @return \StructType\Availability
     */
    public function setAvailableDate($availableDate = null)
    {
        // validation for constraint: string
        if (!is_null($availableDate) && !is_string($availableDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($availableDate)), __LINE__);
        }
        $this->AvailableDate = $availableDate;
        return $this;
    }
    /**
     * Get LastActionCode value
     * @return string|null
     */
    public function getLastActionCode()
    {
        return $this->LastActionCode;
    }
    /**
     * Set LastActionCode value
     * @param string $lastActionCode
     * @return \StructType\Availability
     */
    public function setLastActionCode($lastActionCode = null)
    {
        // validation for constraint: string
        if (!is_null($lastActionCode) && !is_string($lastActionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastActionCode)), __LINE__);
        }
        $this->LastActionCode = $lastActionCode;
        return $this;
    }
    /**
     * Get LastActionDesc value
     * @return string|null
     */
    public function getLastActionDesc()
    {
        return $this->LastActionDesc;
    }
    /**
     * Set LastActionDesc value
     * @param string $lastActionDesc
     * @return \StructType\Availability
     */
    public function setLastActionDesc($lastActionDesc = null)
    {
        // validation for constraint: string
        if (!is_null($lastActionDesc) && !is_string($lastActionDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastActionDesc)), __LINE__);
        }
        $this->LastActionDesc = $lastActionDesc;
        return $this;
    }
    /**
     * Get VacantDate value
     * @return string|null
     */
    public function getVacantDate()
    {
        return $this->VacantDate;
    }
    /**
     * Set VacantDate value
     * @param string $vacantDate
     * @return \StructType\Availability
     */
    public function setVacantDate($vacantDate = null)
    {
        // validation for constraint: string
        if (!is_null($vacantDate) && !is_string($vacantDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vacantDate)), __LINE__);
        }
        $this->VacantDate = $vacantDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Availability
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
