<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Accessibility StructType
 * @subpackage Structs
 */
class Accessibility extends AbstractStructBase
{
    /**
     * The HearingBit
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $HearingBit;
    /**
     * The MobilityBit
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $MobilityBit;
    /**
     * The VisionBit
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $VisionBit;
    /**
     * Constructor method for Accessibility
     * @uses Accessibility::setHearingBit()
     * @uses Accessibility::setMobilityBit()
     * @uses Accessibility::setVisionBit()
     * @param bool $hearingBit
     * @param bool $mobilityBit
     * @param bool $visionBit
     */
    public function __construct($hearingBit = null, $mobilityBit = null, $visionBit = null)
    {
        $this
            ->setHearingBit($hearingBit)
            ->setMobilityBit($mobilityBit)
            ->setVisionBit($visionBit);
    }
    /**
     * Get HearingBit value
     * @return bool
     */
    public function getHearingBit()
    {
        return $this->HearingBit;
    }
    /**
     * Set HearingBit value
     * @param bool $hearingBit
     * @return \StructType\Accessibility
     */
    public function setHearingBit($hearingBit = null)
    {
        // validation for constraint: boolean
        if (!is_null($hearingBit) && !is_bool($hearingBit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hearingBit)), __LINE__);
        }
        $this->HearingBit = $hearingBit;
        return $this;
    }
    /**
     * Get MobilityBit value
     * @return bool
     */
    public function getMobilityBit()
    {
        return $this->MobilityBit;
    }
    /**
     * Set MobilityBit value
     * @param bool $mobilityBit
     * @return \StructType\Accessibility
     */
    public function setMobilityBit($mobilityBit = null)
    {
        // validation for constraint: boolean
        if (!is_null($mobilityBit) && !is_bool($mobilityBit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($mobilityBit)), __LINE__);
        }
        $this->MobilityBit = $mobilityBit;
        return $this;
    }
    /**
     * Get VisionBit value
     * @return bool
     */
    public function getVisionBit()
    {
        return $this->VisionBit;
    }
    /**
     * Set VisionBit value
     * @param bool $visionBit
     * @return \StructType\Accessibility
     */
    public function setVisionBit($visionBit = null)
    {
        // validation for constraint: boolean
        if (!is_null($visionBit) && !is_bool($visionBit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($visionBit)), __LINE__);
        }
        $this->VisionBit = $visionBit;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Accessibility
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
