<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for List ServiceType
 * @subpackage Services
 */
class _List extends AbstractSoapClientBase
{
    /**
     * Sets the UserAuthInfo SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\UserAuthInfo $userAuthInfo
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderUserAuthInfo(\StructType\UserAuthInfo $userAuthInfo, $nameSpace = 'http://realpage.com/webservices', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'UserAuthInfo', $userAuthInfo, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named List
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: UserAuthInfo
     * - SOAPHeaderNamespaces: http://realpage.com/webservices
     * - SOAPHeaderTypes: \StructType\UserAuthInfo
     * - SOAPHeaders: required
     * - documentation: list unit information, including availability and pricing
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\_List $parameters
     * @return \StructType\ListResponse|bool
     */
    public function _List(\StructType\_List $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->List($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ListResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
