<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for rentMatrix StructType
 * @subpackage Structs
 */
class RentMatrix extends AbstractStructBase
{
    /**
     * The row
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Row[]
     */
    public $row;
    /**
     * The LeaseTerm
     * @var string
     */
    public $LeaseTerm;
    /**
     * The LeaseTermMax
     * @var string
     */
    public $LeaseTermMax;
    /**
     * The LeaseTermMin
     * @var string
     */
    public $LeaseTermMin;
    /**
     * The NeededByDate
     * @var string
     */
    public $NeededByDate;
    /**
     * The PropertyID
     * @var string
     */
    public $PropertyID;
    /**
     * Constructor method for rentMatrix
     * @uses RentMatrix::setRow()
     * @uses RentMatrix::setLeaseTerm()
     * @uses RentMatrix::setLeaseTermMax()
     * @uses RentMatrix::setLeaseTermMin()
     * @uses RentMatrix::setNeededByDate()
     * @uses RentMatrix::setPropertyID()
     * @param \StructType\Row[] $row
     * @param string $leaseTerm
     * @param string $leaseTermMax
     * @param string $leaseTermMin
     * @param string $neededByDate
     * @param string $propertyID
     */
    public function __construct(array $row = array(), $leaseTerm = null, $leaseTermMax = null, $leaseTermMin = null, $neededByDate = null, $propertyID = null)
    {
        $this
            ->setRow($row)
            ->setLeaseTerm($leaseTerm)
            ->setLeaseTermMax($leaseTermMax)
            ->setLeaseTermMin($leaseTermMin)
            ->setNeededByDate($neededByDate)
            ->setPropertyID($propertyID);
    }
    /**
     * Get row value
     * @return \StructType\Row[]|null
     */
    public function getRow()
    {
        return $this->row;
    }
    /**
     * Set row value
     * @throws \InvalidArgumentException
     * @param \StructType\Row[] $row
     * @return \StructType\RentMatrix
     */
    public function setRow(array $row = array())
    {
        foreach ($row as $rentMatrixRowItem) {
            // validation for constraint: itemType
            if (!$rentMatrixRowItem instanceof \StructType\Row) {
                throw new \InvalidArgumentException(sprintf('The row property can only contain items of \StructType\Row, "%s" given', is_object($rentMatrixRowItem) ? get_class($rentMatrixRowItem) : gettype($rentMatrixRowItem)), __LINE__);
            }
        }
        $this->row = $row;
        return $this;
    }
    /**
     * Add item to row value
     * @throws \InvalidArgumentException
     * @param \StructType\Row $item
     * @return \StructType\RentMatrix
     */
    public function addToRow(\StructType\Row $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Row) {
            throw new \InvalidArgumentException(sprintf('The row property can only contain items of \StructType\Row, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->row[] = $item;
        return $this;
    }
    /**
     * Get LeaseTerm value
     * @return string|null
     */
    public function getLeaseTerm()
    {
        return $this->LeaseTerm;
    }
    /**
     * Set LeaseTerm value
     * @param string $leaseTerm
     * @return \StructType\RentMatrix
     */
    public function setLeaseTerm($leaseTerm = null)
    {
        // validation for constraint: string
        if (!is_null($leaseTerm) && !is_string($leaseTerm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($leaseTerm)), __LINE__);
        }
        $this->LeaseTerm = $leaseTerm;
        return $this;
    }
    /**
     * Get LeaseTermMax value
     * @return string|null
     */
    public function getLeaseTermMax()
    {
        return $this->LeaseTermMax;
    }
    /**
     * Set LeaseTermMax value
     * @param string $leaseTermMax
     * @return \StructType\RentMatrix
     */
    public function setLeaseTermMax($leaseTermMax = null)
    {
        // validation for constraint: string
        if (!is_null($leaseTermMax) && !is_string($leaseTermMax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($leaseTermMax)), __LINE__);
        }
        $this->LeaseTermMax = $leaseTermMax;
        return $this;
    }
    /**
     * Get LeaseTermMin value
     * @return string|null
     */
    public function getLeaseTermMin()
    {
        return $this->LeaseTermMin;
    }
    /**
     * Set LeaseTermMin value
     * @param string $leaseTermMin
     * @return \StructType\RentMatrix
     */
    public function setLeaseTermMin($leaseTermMin = null)
    {
        // validation for constraint: string
        if (!is_null($leaseTermMin) && !is_string($leaseTermMin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($leaseTermMin)), __LINE__);
        }
        $this->LeaseTermMin = $leaseTermMin;
        return $this;
    }
    /**
     * Get NeededByDate value
     * @return string|null
     */
    public function getNeededByDate()
    {
        return $this->NeededByDate;
    }
    /**
     * Set NeededByDate value
     * @param string $neededByDate
     * @return \StructType\RentMatrix
     */
    public function setNeededByDate($neededByDate = null)
    {
        // validation for constraint: string
        if (!is_null($neededByDate) && !is_string($neededByDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($neededByDate)), __LINE__);
        }
        $this->NeededByDate = $neededByDate;
        return $this;
    }
    /**
     * Get PropertyID value
     * @return string|null
     */
    public function getPropertyID()
    {
        return $this->PropertyID;
    }
    /**
     * Set PropertyID value
     * @param string $propertyID
     * @return \StructType\RentMatrix
     */
    public function setPropertyID($propertyID = null)
    {
        // validation for constraint: string
        if (!is_null($propertyID) && !is_string($propertyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($propertyID)), __LINE__);
        }
        $this->PropertyID = $propertyID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RentMatrix
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
