<?php

namespace EnumType;

/**
 * This class stands for ListType EnumType
 * @subpackage Enumerations
 */
class ListType
{
    /**
     * Constant for value 'LIST_CONTACT'
     * @return string 'LIST_CONTACT'
     */
    const VALUE_LIST_CONTACT = 'LIST_CONTACT';
    /**
     * Constant for value 'LIST_FLOORPLANGROUP'
     * @return string 'LIST_FLOORPLANGROUP'
     */
    const VALUE_LIST_FLOORPLANGROUP = 'LIST_FLOORPLANGROUP';
    /**
     * Constant for value 'LIST_JOB'
     * @return string 'LIST_JOB'
     */
    const VALUE_LIST_JOB = 'LIST_JOB';
    /**
     * Constant for value 'LIST_LATEMETHOD'
     * @return string 'LIST_LATEMETHOD'
     */
    const VALUE_LIST_LATEMETHOD = 'LIST_LATEMETHOD';
    /**
     * Constant for value 'LIST_LEADSOURCE'
     * @return string 'LIST_LEADSOURCE'
     */
    const VALUE_LIST_LEADSOURCE = 'LIST_LEADSOURCE';
    /**
     * Constant for value 'LIST_LEASEREASON'
     * @return string 'LIST_LEASEREASON'
     */
    const VALUE_LIST_LEASEREASON = 'LIST_LEASEREASON';
    /**
     * Constant for value 'LIST_LEASETERM'
     * @return string 'LIST_LEASETERM'
     */
    const VALUE_LIST_LEASETERM = 'LIST_LEASETERM';
    /**
     * Constant for value 'LIST_OPTIONS'
     * @return string 'LIST_OPTIONS'
     */
    const VALUE_LIST_OPTIONS = 'LIST_OPTIONS';
    /**
     * Constant for value 'LIST_PET'
     * @return string 'LIST_PET'
     */
    const VALUE_LIST_PET = 'LIST_PET';
    /**
     * Constant for value 'LIST_PETWEIGHT'
     * @return string 'LIST_PETWEIGHT'
     */
    const VALUE_LIST_PETWEIGHT = 'LIST_PETWEIGHT';
    /**
     * Constant for value 'LIST_PRICERANGE'
     * @return string 'LIST_PRICERANGE'
     */
    const VALUE_LIST_PRICERANGE = 'LIST_PRICERANGE';
    /**
     * Constant for value 'LIST_RELATION'
     * @return string 'LIST_RELATION'
     */
    const VALUE_LIST_RELATION = 'LIST_RELATION';
    /**
     * Constant for value 'LIST_VEHICLE'
     * @return string 'LIST_VEHICLE'
     */
    const VALUE_LIST_VEHICLE = 'LIST_VEHICLE';
    /**
     * Constant for value 'LIST_BUILDING'
     * @return string 'LIST_BUILDING'
     */
    const VALUE_LIST_BUILDING = 'LIST_BUILDING';
    /**
     * Constant for value 'LIST_FLOORPLANCODEANDNAME'
     * @return string 'LIST_FLOORPLANCODEANDNAME'
     */
    const VALUE_LIST_FLOORPLANCODEANDNAME = 'LIST_FLOORPLANCODEANDNAME';
    /**
     * Constant for value 'LIST_FLOORPLANIDANDCODE'
     * @return string 'LIST_FLOORPLANIDANDCODE'
     */
    const VALUE_LIST_FLOORPLANIDANDCODE = 'LIST_FLOORPLANIDANDCODE';
    /**
     * Constant for value 'LIST_FLOORPLANIDANDNAME'
     * @return string 'LIST_FLOORPLANIDANDNAME'
     */
    const VALUE_LIST_FLOORPLANIDANDNAME = 'LIST_FLOORPLANIDANDNAME';
    /**
     * Constant for value 'LIST_PHONETYPE'
     * @return string 'LIST_PHONETYPE'
     */
    const VALUE_LIST_PHONETYPE = 'LIST_PHONETYPE';
    /**
     * Constant for value 'LIST_TRAFFICSOURCE'
     * @return string 'LIST_TRAFFICSOURCE'
     */
    const VALUE_LIST_TRAFFICSOURCE = 'LIST_TRAFFICSOURCE';
    /**
     * Constant for value 'LIST_UNIT'
     * @return string 'LIST_UNIT'
     */
    const VALUE_LIST_UNIT = 'LIST_UNIT';
    /**
     * Constant for value 'LIST_LEASINGAGENT'
     * @return string 'LIST_LEASINGAGENT'
     */
    const VALUE_LIST_LEASINGAGENT = 'LIST_LEASINGAGENT';
    /**
     * Constant for value 'LIST_REASONMOVING'
     * @return string 'LIST_REASONMOVING'
     */
    const VALUE_LIST_REASONMOVING = 'LIST_REASONMOVING';
    /**
     * Constant for value 'LIST_ACTIVITYLOSSREASON'
     * @return string 'LIST_ACTIVITYLOSSREASON'
     */
    const VALUE_LIST_ACTIVITYLOSSREASON = 'LIST_ACTIVITYLOSSREASON';
    /**
     * Constant for value 'LIST_ACTIVITYRESULTCODE'
     * @return string 'LIST_ACTIVITYRESULTCODE'
     */
    const VALUE_LIST_ACTIVITYRESULTCODE = 'LIST_ACTIVITYRESULTCODE';
    /**
     * Constant for value 'LIST_ACTIVITYTYPE'
     * @return string 'LIST_ACTIVITYTYPE'
     */
    const VALUE_LIST_ACTIVITYTYPE = 'LIST_ACTIVITYTYPE';
    /**
     * Constant for value 'LIST_TASKPRIORITY'
     * @return string 'LIST_TASKPRIORITY'
     */
    const VALUE_LIST_TASKPRIORITY = 'LIST_TASKPRIORITY';
    /**
     * Constant for value 'LIST_TASKCATEGORY'
     * @return string 'LIST_TASKCATEGORY'
     */
    const VALUE_LIST_TASKCATEGORY = 'LIST_TASKCATEGORY';
    /**
     * Constant for value 'LIST_PROSPECTSTATUS'
     * @return string 'LIST_PROSPECTSTATUS'
     */
    const VALUE_LIST_PROSPECTSTATUS = 'LIST_PROSPECTSTATUS';
    /**
     * Constant for value 'LIST_ALLFLOORPLAN'
     * @return string 'LIST_ALLFLOORPLAN'
     */
    const VALUE_LIST_ALLFLOORPLAN = 'LIST_ALLFLOORPLAN';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_LIST_CONTACT
     * @uses self::VALUE_LIST_FLOORPLANGROUP
     * @uses self::VALUE_LIST_JOB
     * @uses self::VALUE_LIST_LATEMETHOD
     * @uses self::VALUE_LIST_LEADSOURCE
     * @uses self::VALUE_LIST_LEASEREASON
     * @uses self::VALUE_LIST_LEASETERM
     * @uses self::VALUE_LIST_OPTIONS
     * @uses self::VALUE_LIST_PET
     * @uses self::VALUE_LIST_PETWEIGHT
     * @uses self::VALUE_LIST_PRICERANGE
     * @uses self::VALUE_LIST_RELATION
     * @uses self::VALUE_LIST_VEHICLE
     * @uses self::VALUE_LIST_BUILDING
     * @uses self::VALUE_LIST_FLOORPLANCODEANDNAME
     * @uses self::VALUE_LIST_FLOORPLANIDANDCODE
     * @uses self::VALUE_LIST_FLOORPLANIDANDNAME
     * @uses self::VALUE_LIST_PHONETYPE
     * @uses self::VALUE_LIST_TRAFFICSOURCE
     * @uses self::VALUE_LIST_UNIT
     * @uses self::VALUE_LIST_LEASINGAGENT
     * @uses self::VALUE_LIST_REASONMOVING
     * @uses self::VALUE_LIST_ACTIVITYLOSSREASON
     * @uses self::VALUE_LIST_ACTIVITYRESULTCODE
     * @uses self::VALUE_LIST_ACTIVITYTYPE
     * @uses self::VALUE_LIST_TASKPRIORITY
     * @uses self::VALUE_LIST_TASKCATEGORY
     * @uses self::VALUE_LIST_PROSPECTSTATUS
     * @uses self::VALUE_LIST_ALLFLOORPLAN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_LIST_CONTACT,
            self::VALUE_LIST_FLOORPLANGROUP,
            self::VALUE_LIST_JOB,
            self::VALUE_LIST_LATEMETHOD,
            self::VALUE_LIST_LEADSOURCE,
            self::VALUE_LIST_LEASEREASON,
            self::VALUE_LIST_LEASETERM,
            self::VALUE_LIST_OPTIONS,
            self::VALUE_LIST_PET,
            self::VALUE_LIST_PETWEIGHT,
            self::VALUE_LIST_PRICERANGE,
            self::VALUE_LIST_RELATION,
            self::VALUE_LIST_VEHICLE,
            self::VALUE_LIST_BUILDING,
            self::VALUE_LIST_FLOORPLANCODEANDNAME,
            self::VALUE_LIST_FLOORPLANIDANDCODE,
            self::VALUE_LIST_FLOORPLANIDANDNAME,
            self::VALUE_LIST_PHONETYPE,
            self::VALUE_LIST_TRAFFICSOURCE,
            self::VALUE_LIST_UNIT,
            self::VALUE_LIST_LEASINGAGENT,
            self::VALUE_LIST_REASONMOVING,
            self::VALUE_LIST_ACTIVITYLOSSREASON,
            self::VALUE_LIST_ACTIVITYRESULTCODE,
            self::VALUE_LIST_ACTIVITYTYPE,
            self::VALUE_LIST_TASKPRIORITY,
            self::VALUE_LIST_TASKCATEGORY,
            self::VALUE_LIST_PROSPECTSTATUS,
            self::VALUE_LIST_ALLFLOORPLAN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
