<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfUnitObject ArrayType
 * @subpackage Arrays
 */
class ArrayOfUnitObject extends AbstractStructArrayBase
{
    /**
     * The UnitObject
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\UnitObject[]
     */
    public $UnitObject;
    /**
     * Constructor method for ArrayOfUnitObject
     * @uses ArrayOfUnitObject::setUnitObject()
     * @param \StructType\UnitObject[] $unitObject
     */
    public function __construct(array $unitObject = array())
    {
        $this
            ->setUnitObject($unitObject);
    }
    /**
     * Get UnitObject value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\UnitObject[]|null
     */
    public function getUnitObject()
    {
        return isset($this->UnitObject) ? $this->UnitObject : null;
    }
    /**
     * Set UnitObject value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\UnitObject[] $unitObject
     * @return \ArrayType\ArrayOfUnitObject
     */
    public function setUnitObject(array $unitObject = array())
    {
        foreach ($unitObject as $arrayOfUnitObjectUnitObjectItem) {
            // validation for constraint: itemType
            if (!$arrayOfUnitObjectUnitObjectItem instanceof \StructType\UnitObject) {
                throw new \InvalidArgumentException(sprintf('The UnitObject property can only contain items of \StructType\UnitObject, "%s" given', is_object($arrayOfUnitObjectUnitObjectItem) ? get_class($arrayOfUnitObjectUnitObjectItem) : gettype($arrayOfUnitObjectUnitObjectItem)), __LINE__);
            }
        }
        if (is_null($unitObject) || (is_array($unitObject) && empty($unitObject))) {
            unset($this->UnitObject);
        } else {
            $this->UnitObject = $unitObject;
        }
        return $this;
    }
    /**
     * Add item to UnitObject value
     * @throws \InvalidArgumentException
     * @param \StructType\UnitObject $item
     * @return \ArrayType\ArrayOfUnitObject
     */
    public function addToUnitObject(\StructType\UnitObject $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UnitObject) {
            throw new \InvalidArgumentException(sprintf('The UnitObject property can only contain items of \StructType\UnitObject, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->UnitObject[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\UnitObject|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\UnitObject|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\UnitObject|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\UnitObject|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\UnitObject|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string UnitObject
     */
    public function getAttributeName()
    {
        return 'UnitObject';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfUnitObject
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
