<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRentMatrix ArrayType
 * @subpackage Arrays
 */
class ArrayOfRentMatrix extends AbstractStructArrayBase
{
    /**
     * The RentMatrix
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RentMatrix_1[]
     */
    public $RentMatrix;
    /**
     * Constructor method for ArrayOfRentMatrix
     * @uses ArrayOfRentMatrix::setRentMatrix()
     * @param \StructType\RentMatrix_1[] $rentMatrix
     */
    public function __construct(array $rentMatrix = array())
    {
        $this
            ->setRentMatrix($rentMatrix);
    }
    /**
     * Get RentMatrix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RentMatrix_1[]|null
     */
    public function getRentMatrix()
    {
        return isset($this->RentMatrix) ? $this->RentMatrix : null;
    }
    /**
     * Set RentMatrix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\RentMatrix_1[] $rentMatrix
     * @return \ArrayType\ArrayOfRentMatrix
     */
    public function setRentMatrix(array $rentMatrix = array())
    {
        foreach ($rentMatrix as $arrayOfRentMatrixRentMatrixItem) {
            // validation for constraint: itemType
            if (!$arrayOfRentMatrixRentMatrixItem instanceof \StructType\RentMatrix_1) {
                throw new \InvalidArgumentException(sprintf('The RentMatrix property can only contain items of \StructType\RentMatrix_1, "%s" given', is_object($arrayOfRentMatrixRentMatrixItem) ? get_class($arrayOfRentMatrixRentMatrixItem) : gettype($arrayOfRentMatrixRentMatrixItem)), __LINE__);
            }
        }
        if (is_null($rentMatrix) || (is_array($rentMatrix) && empty($rentMatrix))) {
            unset($this->RentMatrix);
        } else {
            $this->RentMatrix = $rentMatrix;
        }
        return $this;
    }
    /**
     * Add item to RentMatrix value
     * @throws \InvalidArgumentException
     * @param \StructType\RentMatrix_1 $item
     * @return \ArrayType\ArrayOfRentMatrix
     */
    public function addToRentMatrix(\StructType\RentMatrix_1 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RentMatrix_1) {
            throw new \InvalidArgumentException(sprintf('The RentMatrix property can only contain items of \StructType\RentMatrix_1, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RentMatrix[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\RentMatrix_1|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\RentMatrix_1|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\RentMatrix_1|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\RentMatrix_1|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\RentMatrix_1|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string RentMatrix
     */
    public function getAttributeName()
    {
        return 'RentMatrix';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfRentMatrix
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
