<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfListCriterion ArrayType
 * @subpackage Arrays
 */
class ArrayOfListCriterion extends AbstractStructArrayBase
{
    /**
     * The ListCriterion
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ListCriterion[]
     */
    public $ListCriterion;
    /**
     * Constructor method for ArrayOfListCriterion
     * @uses ArrayOfListCriterion::setListCriterion()
     * @param \StructType\ListCriterion[] $listCriterion
     */
    public function __construct(array $listCriterion = array())
    {
        $this
            ->setListCriterion($listCriterion);
    }
    /**
     * Get ListCriterion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ListCriterion[]|null
     */
    public function getListCriterion()
    {
        return isset($this->ListCriterion) ? $this->ListCriterion : null;
    }
    /**
     * Set ListCriterion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ListCriterion[] $listCriterion
     * @return \ArrayType\ArrayOfListCriterion
     */
    public function setListCriterion(array $listCriterion = array())
    {
        foreach ($listCriterion as $arrayOfListCriterionListCriterionItem) {
            // validation for constraint: itemType
            if (!$arrayOfListCriterionListCriterionItem instanceof \StructType\ListCriterion) {
                throw new \InvalidArgumentException(sprintf('The ListCriterion property can only contain items of \StructType\ListCriterion, "%s" given', is_object($arrayOfListCriterionListCriterionItem) ? get_class($arrayOfListCriterionListCriterionItem) : gettype($arrayOfListCriterionListCriterionItem)), __LINE__);
            }
        }
        if (is_null($listCriterion) || (is_array($listCriterion) && empty($listCriterion))) {
            unset($this->ListCriterion);
        } else {
            $this->ListCriterion = $listCriterion;
        }
        return $this;
    }
    /**
     * Add item to ListCriterion value
     * @throws \InvalidArgumentException
     * @param \StructType\ListCriterion $item
     * @return \ArrayType\ArrayOfListCriterion
     */
    public function addToListCriterion(\StructType\ListCriterion $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ListCriterion) {
            throw new \InvalidArgumentException(sprintf('The ListCriterion property can only contain items of \StructType\ListCriterion, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ListCriterion[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ListCriterion|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ListCriterion|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ListCriterion|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ListCriterion|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ListCriterion|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ListCriterion
     */
    public function getAttributeName()
    {
        return 'ListCriterion';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfListCriterion
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
