<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PickListObject StructType
 * @subpackage Structs
 */
class PickListObject extends AbstractStructBase
{
    /**
     * The ContentType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ContentType;
    /**
     * The Contents
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfPicklistItem
     */
    public $Contents;
    /**
     * Constructor method for PickListObject
     * @uses PickListObject::setContentType()
     * @uses PickListObject::setContents()
     * @param string $contentType
     * @param \ArrayType\ArrayOfPicklistItem $contents
     */
    public function __construct($contentType = null, \ArrayType\ArrayOfPicklistItem $contents = null)
    {
        $this
            ->setContentType($contentType)
            ->setContents($contents);
    }
    /**
     * Get ContentType value
     * @return string
     */
    public function getContentType()
    {
        return $this->ContentType;
    }
    /**
     * Set ContentType value
     * @uses \EnumType\ListType::valueIsValid()
     * @uses \EnumType\ListType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $contentType
     * @return \StructType\PickListObject
     */
    public function setContentType($contentType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ListType::valueIsValid($contentType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $contentType, implode(', ', \EnumType\ListType::getValidValues())), __LINE__);
        }
        $this->ContentType = $contentType;
        return $this;
    }
    /**
     * Get Contents value
     * @return \ArrayType\ArrayOfPicklistItem|null
     */
    public function getContents()
    {
        return $this->Contents;
    }
    /**
     * Set Contents value
     * @param \ArrayType\ArrayOfPicklistItem $contents
     * @return \StructType\PickListObject
     */
    public function setContents(\ArrayType\ArrayOfPicklistItem $contents = null)
    {
        $this->Contents = $contents;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PickListObject
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
