<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for options StructType
 * @subpackage Structs
 */
class Options extends AbstractStructBase
{
    /**
     * The option
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Option[]
     */
    public $option;
    /**
     * The LeaseStartDate
     * @var string
     */
    public $LeaseStartDate;
    /**
     * Constructor method for options
     * @uses Options::setOption()
     * @uses Options::setLeaseStartDate()
     * @param \StructType\Option[] $option
     * @param string $leaseStartDate
     */
    public function __construct(array $option = array(), $leaseStartDate = null)
    {
        $this
            ->setOption($option)
            ->setLeaseStartDate($leaseStartDate);
    }
    /**
     * Get option value
     * @return \StructType\Option[]|null
     */
    public function getOption()
    {
        return $this->option;
    }
    /**
     * Set option value
     * @throws \InvalidArgumentException
     * @param \StructType\Option[] $option
     * @return \StructType\Options
     */
    public function setOption(array $option = array())
    {
        foreach ($option as $optionsOptionItem) {
            // validation for constraint: itemType
            if (!$optionsOptionItem instanceof \StructType\Option) {
                throw new \InvalidArgumentException(sprintf('The option property can only contain items of \StructType\Option, "%s" given', is_object($optionsOptionItem) ? get_class($optionsOptionItem) : gettype($optionsOptionItem)), __LINE__);
            }
        }
        $this->option = $option;
        return $this;
    }
    /**
     * Add item to option value
     * @throws \InvalidArgumentException
     * @param \StructType\Option $item
     * @return \StructType\Options
     */
    public function addToOption(\StructType\Option $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Option) {
            throw new \InvalidArgumentException(sprintf('The option property can only contain items of \StructType\Option, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->option[] = $item;
        return $this;
    }
    /**
     * Get LeaseStartDate value
     * @return string|null
     */
    public function getLeaseStartDate()
    {
        return $this->LeaseStartDate;
    }
    /**
     * Set LeaseStartDate value
     * @param string $leaseStartDate
     * @return \StructType\Options
     */
    public function setLeaseStartDate($leaseStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($leaseStartDate) && !is_string($leaseStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($leaseStartDate)), __LINE__);
        }
        $this->LeaseStartDate = $leaseStartDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Options
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
