<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for option StructType
 * @subpackage Structs
 */
class Option extends AbstractStructBase
{
    /**
     * The Best
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $Best;
    /**
     * The Concessions
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Concessions[]
     */
    public $Concessions;
    /**
     * The LeaseEndDate
     * @var string
     */
    public $LeaseEndDate;
    /**
     * The LeaseTerm
     * @var string
     */
    public $LeaseTerm;
    /**
     * The Rent
     * @var string
     */
    public $Rent;
    /**
     * Constructor method for option
     * @uses Option::setBest()
     * @uses Option::setConcessions()
     * @uses Option::setLeaseEndDate()
     * @uses Option::setLeaseTerm()
     * @uses Option::setRent()
     * @param bool $best
     * @param \StructType\Concessions[] $concessions
     * @param string $leaseEndDate
     * @param string $leaseTerm
     * @param string $rent
     */
    public function __construct($best = null, array $concessions = array(), $leaseEndDate = null, $leaseTerm = null, $rent = null)
    {
        $this
            ->setBest($best)
            ->setConcessions($concessions)
            ->setLeaseEndDate($leaseEndDate)
            ->setLeaseTerm($leaseTerm)
            ->setRent($rent);
    }
    /**
     * Get Best value
     * @return bool
     */
    public function getBest()
    {
        return $this->Best;
    }
    /**
     * Set Best value
     * @param bool $best
     * @return \StructType\Option
     */
    public function setBest($best = null)
    {
        // validation for constraint: boolean
        if (!is_null($best) && !is_bool($best)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($best)), __LINE__);
        }
        $this->Best = $best;
        return $this;
    }
    /**
     * Get Concessions value
     * @return \StructType\Concessions[]|null
     */
    public function getConcessions()
    {
        return $this->Concessions;
    }
    /**
     * Set Concessions value
     * @throws \InvalidArgumentException
     * @param \StructType\Concessions[] $concessions
     * @return \StructType\Option
     */
    public function setConcessions(array $concessions = array())
    {
        foreach ($concessions as $optionConcessionsItem) {
            // validation for constraint: itemType
            if (!$optionConcessionsItem instanceof \StructType\Concessions) {
                throw new \InvalidArgumentException(sprintf('The Concessions property can only contain items of \StructType\Concessions, "%s" given', is_object($optionConcessionsItem) ? get_class($optionConcessionsItem) : gettype($optionConcessionsItem)), __LINE__);
            }
        }
        $this->Concessions = $concessions;
        return $this;
    }
    /**
     * Add item to Concessions value
     * @throws \InvalidArgumentException
     * @param \StructType\Concessions $item
     * @return \StructType\Option
     */
    public function addToConcessions(\StructType\Concessions $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Concessions) {
            throw new \InvalidArgumentException(sprintf('The Concessions property can only contain items of \StructType\Concessions, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Concessions[] = $item;
        return $this;
    }
    /**
     * Get LeaseEndDate value
     * @return string|null
     */
    public function getLeaseEndDate()
    {
        return $this->LeaseEndDate;
    }
    /**
     * Set LeaseEndDate value
     * @param string $leaseEndDate
     * @return \StructType\Option
     */
    public function setLeaseEndDate($leaseEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($leaseEndDate) && !is_string($leaseEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($leaseEndDate)), __LINE__);
        }
        $this->LeaseEndDate = $leaseEndDate;
        return $this;
    }
    /**
     * Get LeaseTerm value
     * @return string|null
     */
    public function getLeaseTerm()
    {
        return $this->LeaseTerm;
    }
    /**
     * Set LeaseTerm value
     * @param string $leaseTerm
     * @return \StructType\Option
     */
    public function setLeaseTerm($leaseTerm = null)
    {
        // validation for constraint: string
        if (!is_null($leaseTerm) && !is_string($leaseTerm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($leaseTerm)), __LINE__);
        }
        $this->LeaseTerm = $leaseTerm;
        return $this;
    }
    /**
     * Get Rent value
     * @return string|null
     */
    public function getRent()
    {
        return $this->Rent;
    }
    /**
     * Set Rent value
     * @param string $rent
     * @return \StructType\Option
     */
    public function setRent($rent = null)
    {
        // validation for constraint: string
        if (!is_null($rent) && !is_string($rent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rent)), __LINE__);
        }
        $this->Rent = $rent;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Option
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
