<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetRentMatrix StructType
 * @subpackage Structs
 */
class GetRentMatrix extends AbstractStructBase
{
    /**
     * The NeededByDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $NeededByDate;
    /**
     * The LeaseTerm
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LeaseTerm;
    /**
     * The includeAllLeaseTerms
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $includeAllLeaseTerms;
    /**
     * The UnitIDs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInt
     */
    public $UnitIDs;
    /**
     * Constructor method for GetRentMatrix
     * @uses GetRentMatrix::setNeededByDate()
     * @uses GetRentMatrix::setLeaseTerm()
     * @uses GetRentMatrix::setIncludeAllLeaseTerms()
     * @uses GetRentMatrix::setUnitIDs()
     * @param string $neededByDate
     * @param int $leaseTerm
     * @param bool $includeAllLeaseTerms
     * @param \ArrayType\ArrayOfInt $unitIDs
     */
    public function __construct($neededByDate = null, $leaseTerm = null, $includeAllLeaseTerms = null, \ArrayType\ArrayOfInt $unitIDs = null)
    {
        $this
            ->setNeededByDate($neededByDate)
            ->setLeaseTerm($leaseTerm)
            ->setIncludeAllLeaseTerms($includeAllLeaseTerms)
            ->setUnitIDs($unitIDs);
    }
    /**
     * Get NeededByDate value
     * @return string
     */
    public function getNeededByDate()
    {
        return $this->NeededByDate;
    }
    /**
     * Set NeededByDate value
     * @param string $neededByDate
     * @return \StructType\GetRentMatrix
     */
    public function setNeededByDate($neededByDate = null)
    {
        // validation for constraint: string
        if (!is_null($neededByDate) && !is_string($neededByDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($neededByDate)), __LINE__);
        }
        $this->NeededByDate = $neededByDate;
        return $this;
    }
    /**
     * Get LeaseTerm value
     * @return int
     */
    public function getLeaseTerm()
    {
        return $this->LeaseTerm;
    }
    /**
     * Set LeaseTerm value
     * @param int $leaseTerm
     * @return \StructType\GetRentMatrix
     */
    public function setLeaseTerm($leaseTerm = null)
    {
        // validation for constraint: int
        if (!is_null($leaseTerm) && !is_numeric($leaseTerm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($leaseTerm)), __LINE__);
        }
        $this->LeaseTerm = $leaseTerm;
        return $this;
    }
    /**
     * Get includeAllLeaseTerms value
     * @return bool
     */
    public function getIncludeAllLeaseTerms()
    {
        return $this->includeAllLeaseTerms;
    }
    /**
     * Set includeAllLeaseTerms value
     * @param bool $includeAllLeaseTerms
     * @return \StructType\GetRentMatrix
     */
    public function setIncludeAllLeaseTerms($includeAllLeaseTerms = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeAllLeaseTerms) && !is_bool($includeAllLeaseTerms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includeAllLeaseTerms)), __LINE__);
        }
        $this->includeAllLeaseTerms = $includeAllLeaseTerms;
        return $this;
    }
    /**
     * Get UnitIDs value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getUnitIDs()
    {
        return $this->UnitIDs;
    }
    /**
     * Set UnitIDs value
     * @param \ArrayType\ArrayOfInt $unitIDs
     * @return \StructType\GetRentMatrix
     */
    public function setUnitIDs(\ArrayType\ArrayOfInt $unitIDs = null)
    {
        $this->UnitIDs = $unitIDs;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetRentMatrix
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
