<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Sets the UserAuthInfo SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\UserAuthInfo $userAuthInfo
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderUserAuthInfo(\StructType\UserAuthInfo $userAuthInfo, $nameSpace = 'http://realpage.com/webservices', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'UserAuthInfo', $userAuthInfo, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named GetRentMatrix
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: UserAuthInfo
     * - SOAPHeaderNamespaces: http://realpage.com/webservices
     * - SOAPHeaderTypes: \StructType\UserAuthInfo
     * - SOAPHeaders: required
     * - documentation: obtain YSPO rent matrix data for any list of one or more apartments
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetRentMatrix $parameters
     * @return \StructType\GetRentMatrixResponse|bool
     */
    public function GetRentMatrix(\StructType\GetRentMatrix $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetRentMatrix($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetFloorPlanGroupsByProperty
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: UserAuthInfo
     * - SOAPHeaderNamespaces: http://realpage.com/webservices
     * - SOAPHeaderTypes: \StructType\UserAuthInfo
     * - SOAPHeaders: required
     * - documentation: Get floor plan groups by property
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetFloorPlanGroupsByProperty $parameters
     * @return \StructType\GetFloorPlanGroupsByPropertyResponse|bool
     */
    public function GetFloorPlanGroupsByProperty(\StructType\GetFloorPlanGroupsByProperty $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetFloorPlanGroupsByProperty($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetFloorPlanIDAndName
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: UserAuthInfo
     * - SOAPHeaderNamespaces: http://realpage.com/webservices
     * - SOAPHeaderTypes: \StructType\UserAuthInfo
     * - SOAPHeaders: required
     * - documentation: Get floor plan ID and name
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetFloorPlanIDAndName $parameters
     * @return \StructType\GetFloorPlanIDAndNameResponse|bool
     */
    public function GetFloorPlanIDAndName(\StructType\GetFloorPlanIDAndName $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetFloorPlanIDAndName($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUnitsByProperty
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: UserAuthInfo
     * - SOAPHeaderNamespaces: http://realpage.com/webservices
     * - SOAPHeaderTypes: \StructType\UserAuthInfo
     * - SOAPHeaders: required
     * - documentation: Get units by property.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetUnitsByProperty $parameters
     * @return \StructType\GetUnitsByPropertyResponse|bool
     */
    public function GetUnitsByProperty(\StructType\GetUnitsByProperty $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetUnitsByProperty($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetFloorPlanGroupsByPropertyResponse|\StructType\GetFloorPlanIDAndNameResponse|\StructType\GetRentMatrixResponse|\StructType\GetUnitsByPropertyResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
