<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPicklistItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfPicklistItem extends AbstractStructArrayBase
{
    /**
     * The PicklistItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PicklistItem[]
     */
    public $PicklistItem;
    /**
     * Constructor method for ArrayOfPicklistItem
     * @uses ArrayOfPicklistItem::setPicklistItem()
     * @param \StructType\PicklistItem[] $picklistItem
     */
    public function __construct(array $picklistItem = array())
    {
        $this
            ->setPicklistItem($picklistItem);
    }
    /**
     * Get PicklistItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PicklistItem[]|null
     */
    public function getPicklistItem()
    {
        return isset($this->PicklistItem) ? $this->PicklistItem : null;
    }
    /**
     * Set PicklistItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PicklistItem[] $picklistItem
     * @return \ArrayType\ArrayOfPicklistItem
     */
    public function setPicklistItem(array $picklistItem = array())
    {
        foreach ($picklistItem as $arrayOfPicklistItemPicklistItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfPicklistItemPicklistItemItem instanceof \StructType\PicklistItem) {
                throw new \InvalidArgumentException(sprintf('The PicklistItem property can only contain items of \StructType\PicklistItem, "%s" given', is_object($arrayOfPicklistItemPicklistItemItem) ? get_class($arrayOfPicklistItemPicklistItemItem) : gettype($arrayOfPicklistItemPicklistItemItem)), __LINE__);
            }
        }
        if (is_null($picklistItem) || (is_array($picklistItem) && empty($picklistItem))) {
            unset($this->PicklistItem);
        } else {
            $this->PicklistItem = $picklistItem;
        }
        return $this;
    }
    /**
     * Add item to PicklistItem value
     * @throws \InvalidArgumentException
     * @param \StructType\PicklistItem $item
     * @return \ArrayType\ArrayOfPicklistItem
     */
    public function addToPicklistItem(\StructType\PicklistItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PicklistItem) {
            throw new \InvalidArgumentException(sprintf('The PicklistItem property can only contain items of \StructType\PicklistItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PicklistItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PicklistItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PicklistItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PicklistItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PicklistItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PicklistItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PicklistItem
     */
    public function getAttributeName()
    {
        return 'PicklistItem';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfPicklistItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
