<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VerfuegbarkeitsantwortArtikel StructType
 * @subpackage Structs
 */
class VerfuegbarkeitsantwortArtikel extends AbstractStructBase
{
    /**
     * The AnfrageMenge
     * Meta informations extracted from the WSDL
     * - maxInclusive: 99999
     * - minInclusive: 1
     * @var int
     */
    public $AnfrageMenge;
    /**
     * The AnfragePzn
     * Meta informations extracted from the WSDL
     * - documentation: PZN oder auch EAN TODO: Restrictions einbauen.
     * @var int
     */
    public $AnfragePzn;
    /**
     * The Substitution
     * Meta informations extracted from the WSDL
     * - documentation: wenn angegeben, wird fuer ALLE Anteile der Substitutionsartikel angenommen (ausser bei Substitutionsgrund "Vorschlag") -> Die Loesung schliesst aus Komplexitaetsgruenden aus, dass man bei Substitution fuer Normallieferung einen
     * Anteil mit und einen anteil ohne Substitution liefern darf!
     * - minOccurs: 0
     * @var \StructType\VerfuegbarkeitSubstitution
     */
    public $Substitution;
    /**
     * The Anteile
     * Meta informations extracted from the WSDL
     * - documentation: maximal 5 Anteile der Rueckmeldung wobei jede Auspraegung von Typ nur 1x benutzt werden darf.
     * - maxOccurs: 5
     * @var \StructType\VerfuegbarkeitAnteil[]
     */
    public $Anteile;
    /**
     * Constructor method for VerfuegbarkeitsantwortArtikel
     * @uses VerfuegbarkeitsantwortArtikel::setAnfrageMenge()
     * @uses VerfuegbarkeitsantwortArtikel::setAnfragePzn()
     * @uses VerfuegbarkeitsantwortArtikel::setSubstitution()
     * @uses VerfuegbarkeitsantwortArtikel::setAnteile()
     * @param int $anfrageMenge
     * @param int $anfragePzn
     * @param \StructType\VerfuegbarkeitSubstitution $substitution
     * @param \StructType\VerfuegbarkeitAnteil[] $anteile
     */
    public function __construct($anfrageMenge = null, $anfragePzn = null, \StructType\VerfuegbarkeitSubstitution $substitution = null, array $anteile = array())
    {
        $this
            ->setAnfrageMenge($anfrageMenge)
            ->setAnfragePzn($anfragePzn)
            ->setSubstitution($substitution)
            ->setAnteile($anteile);
    }
    /**
     * Get AnfrageMenge value
     * @return int|null
     */
    public function getAnfrageMenge()
    {
        return $this->AnfrageMenge;
    }
    /**
     * Set AnfrageMenge value
     * @param int $anfrageMenge
     * @return \StructType\VerfuegbarkeitsantwortArtikel
     */
    public function setAnfrageMenge($anfrageMenge = null)
    {
        $this->AnfrageMenge = $anfrageMenge;
        return $this;
    }
    /**
     * Get AnfragePzn value
     * @return int|null
     */
    public function getAnfragePzn()
    {
        return $this->AnfragePzn;
    }
    /**
     * Set AnfragePzn value
     * @param int $anfragePzn
     * @return \StructType\VerfuegbarkeitsantwortArtikel
     */
    public function setAnfragePzn($anfragePzn = null)
    {
        $this->AnfragePzn = $anfragePzn;
        return $this;
    }
    /**
     * Get Substitution value
     * @return \StructType\VerfuegbarkeitSubstitution|null
     */
    public function getSubstitution()
    {
        return $this->Substitution;
    }
    /**
     * Set Substitution value
     * @param \StructType\VerfuegbarkeitSubstitution $substitution
     * @return \StructType\VerfuegbarkeitsantwortArtikel
     */
    public function setSubstitution(\StructType\VerfuegbarkeitSubstitution $substitution = null)
    {
        $this->Substitution = $substitution;
        return $this;
    }
    /**
     * Get Anteile value
     * @return \StructType\VerfuegbarkeitAnteil[]|null
     */
    public function getAnteile()
    {
        return $this->Anteile;
    }
    /**
     * Set Anteile value
     * @throws \InvalidArgumentException
     * @param \StructType\VerfuegbarkeitAnteil[] $anteile
     * @return \StructType\VerfuegbarkeitsantwortArtikel
     */
    public function setAnteile(array $anteile = array())
    {
        $this->Anteile = $anteile;
        return $this;
    }
    /**
     * Add item to Anteile value
     * @throws \InvalidArgumentException
     * @param \StructType\VerfuegbarkeitAnteil $item
     * @return \StructType\VerfuegbarkeitsantwortArtikel
     */
    public function addToAnteile(\StructType\VerfuegbarkeitAnteil $item)
    {
        $this->Anteile[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VerfuegbarkeitsantwortArtikel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
