<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VerfuegbarkeitAnteil StructType
 * @subpackage Structs
 */
class VerfuegbarkeitAnteil extends AbstractStructBase
{
    /**
     * The Menge
     * Meta informations extracted from the WSDL
     * - documentation: die Summe ALLER Mengenfelder = AnfrageMenge
     * - nillable: true
     * - maxInclusive: 99999
     * - minInclusive: 1
     * @var int
     */
    public $Menge;
    /**
     * The Typ
     * @var string
     */
    public $Typ;
    /**
     * The Lieferzeitpunkt
     * Meta informations extracted from the WSDL
     * - documentation: Voraussichtlich! z.B. 1.1.2011 15:00 Uhr Bei Typ=Normal oder Verbund und spezifischer Rueckmeldung muss enweder Lieferzeitpunkt oder Tour gefuellt sein!
     * - nillable: true
     * @var string
     */
    public $Lieferzeitpunkt;
    /**
     * The Tour
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: optional Tour oder Lieferzeitpunkt ist Pflicht | optional Angabe zur Tour, mit der die enthaltenen Positionen abgeholt werden. Z.B "Mittagstour am 25.05.2015". Sobald mind. eine Position akzeptiert wird, muss entweder Abholzeitpunkt
     * oder die Tour muessen gefuellt sein, sobald eine Retourenmenge akzeptiert wird. | Beschreibung der Tour z.B. "9 Uhr Tour" oder "Mittagstour" Bei Typ=Normal oder Verbund muss enweder Lieferzeitpunkt oder Tour gefuellt sein! | Beschreibung der Tour
     * z.B. "9 Uhr Tour" oder "Mittagstour" Bei Typ=Normal oder Verbund und spezifischer Rueckmeldung muss enweder Lieferzeitpunkt oder Tour gefuellt sein!
     * - maxLength: 80
     * - minLength: 1
     * @var string
     */
    public $Tour;
    /**
     * The Grund
     * Meta informations extracted from the WSDL
     * - documentation: ein definierter Defektgrund Bei Typ=Normal oder Verbund ist der Wert immer "KeineAngabe" , sonst ist bei allen anderen Typen einer der ANDEREN! Werte Pflicht
     * @var string
     */
    public $Grund;
    /**
     * The Tourabweichung
     * Meta informations extracted from the WSDL
     * - documentation: nur bei Typ NORMAL und VERBUND ist true erlaubt; true, wenn wegen BTM oder Kuehlware / Transportausschluss nicht mit der naechsten Tour geliefert werden kann
     * @var bool
     */
    public $Tourabweichung;
    /**
     * Constructor method for VerfuegbarkeitAnteil
     * @uses VerfuegbarkeitAnteil::setMenge()
     * @uses VerfuegbarkeitAnteil::setTyp()
     * @uses VerfuegbarkeitAnteil::setLieferzeitpunkt()
     * @uses VerfuegbarkeitAnteil::setTour()
     * @uses VerfuegbarkeitAnteil::setGrund()
     * @uses VerfuegbarkeitAnteil::setTourabweichung()
     * @param int $menge
     * @param string $typ
     * @param string $lieferzeitpunkt
     * @param string $tour
     * @param string $grund
     * @param bool $tourabweichung
     */
    public function __construct($menge = null, $typ = null, $lieferzeitpunkt = null, $tour = null, $grund = null, $tourabweichung = null)
    {
        $this
            ->setMenge($menge)
            ->setTyp($typ)
            ->setLieferzeitpunkt($lieferzeitpunkt)
            ->setTour($tour)
            ->setGrund($grund)
            ->setTourabweichung($tourabweichung);
    }
    /**
     * Get Menge value
     * @return int|null
     */
    public function getMenge()
    {
        return $this->Menge;
    }
    /**
     * Set Menge value
     * @param int $menge
     * @return \StructType\VerfuegbarkeitAnteil
     */
    public function setMenge($menge = null)
    {
        $this->Menge = $menge;
        return $this;
    }
    /**
     * Get Typ value
     * @return string|null
     */
    public function getTyp()
    {
        return $this->Typ;
    }
    /**
     * Set Typ value
     * @uses \EnumType\VerfuegbarkeitRueckmeldungTyp::valueIsValid()
     * @uses \EnumType\VerfuegbarkeitRueckmeldungTyp::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $typ
     * @return \StructType\VerfuegbarkeitAnteil
     */
    public function setTyp($typ = null)
    {
        $this->Typ = $typ;
        return $this;
    }
    /**
     * Get Lieferzeitpunkt value
     * @return string|null
     */
    public function getLieferzeitpunkt()
    {
        return $this->Lieferzeitpunkt;
    }
    /**
     * Set Lieferzeitpunkt value
     * @param string $lieferzeitpunkt
     * @return \StructType\VerfuegbarkeitAnteil
     */
    public function setLieferzeitpunkt($lieferzeitpunkt = null)
    {
        $this->Lieferzeitpunkt = $lieferzeitpunkt;
        return $this;
    }
    /**
     * Get Tour value
     * @return string|null
     */
    public function getTour()
    {
        return $this->Tour;
    }
    /**
     * Set Tour value
     * @param string $tour
     * @return \StructType\VerfuegbarkeitAnteil
     */
    public function setTour($tour = null)
    {
        $this->Tour = $tour;
        return $this;
    }
    /**
     * Get Grund value
     * @return string|null
     */
    public function getGrund()
    {
        return $this->Grund;
    }
    /**
     * Set Grund value
     * @uses \EnumType\VerfuegbarkeitDefektgrund::valueIsValid()
     * @uses \EnumType\VerfuegbarkeitDefektgrund::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $grund
     * @return \StructType\VerfuegbarkeitAnteil
     */
    public function setGrund($grund = null)
    {
        $this->Grund = $grund;
        return $this;
    }
    /**
     * Get Tourabweichung value
     * @return bool|null
     */
    public function getTourabweichung()
    {
        return $this->Tourabweichung;
    }
    /**
     * Set Tourabweichung value
     * @param bool $tourabweichung
     * @return \StructType\VerfuegbarkeitAnteil
     */
    public function setTourabweichung($tourabweichung = null)
    {
        $this->Tourabweichung = $tourabweichung;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VerfuegbarkeitAnteil
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
