<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetourenavisAnkuendigungType StructType
 * @subpackage Structs
 */
class RetourenavisAnkuendigungType extends AbstractStructBase
{
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - documentation: Vom System zu vergebende eindeutige ID zur Referenzierung durch den GH (GUID) | eindeutige sich nie wiederholende ID des Webservicerequests. (Fuer Benutzung bei AF2 - Nachtraegliche Antwortabfrage fuer eine Bestellung) Datentyp GUID
     * (Primaerschluessel)
     * - use: required
     * - length: 36
     * - pattern: ([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}
     * @var string
     */
    public $ID;
    /**
     * The RetoureSupportID
     * Meta informations extracted from the WSDL
     * - documentation: Ausschliessliche Identifikation fuer Menschen! Dient fuer Rueckfragen beim GH (optional Anzeige auf GUI kein Andruck) - keine technische Semantik Apo-Wawi vergibt diese; soll genuegend Selektiv sein
     * - use: required
     * - maxInclusive: 999999
     * - minInclusive: 1
     * @var int
     */
    public $RetoureSupportID;
    /**
     * The Position
     * Meta informations extracted from the WSDL
     * - maxOccurs: 999
     * @var \StructType\RetourePositionType[]
     */
    public $Position;
    /**
     * The Amtsgericht
     * @var string
     */
    public $Amtsgericht;
    /**
     * The Handelsregisternummer
     * @var string
     */
    public $Handelsregisternummer;
    /**
     * The UmsatzsteuerID
     * @var string
     */
    public $UmsatzsteuerID;
    /**
     * The Steuernummer
     * @var string
     */
    public $Steuernummer;
    /**
     * The Bankname
     * @var string
     */
    public $Bankname;
    /**
     * The BIC
     * @var string
     */
    public $BIC;
    /**
     * The IBAN
     * @var string
     */
    public $IBAN;
    /**
     * Constructor method for RetourenavisAnkuendigungType
     * @uses RetourenavisAnkuendigungType::setID()
     * @uses RetourenavisAnkuendigungType::setRetoureSupportID()
     * @uses RetourenavisAnkuendigungType::setPosition()
     * @uses RetourenavisAnkuendigungType::setAmtsgericht()
     * @uses RetourenavisAnkuendigungType::setHandelsregisternummer()
     * @uses RetourenavisAnkuendigungType::setUmsatzsteuerID()
     * @uses RetourenavisAnkuendigungType::setSteuernummer()
     * @uses RetourenavisAnkuendigungType::setBankname()
     * @uses RetourenavisAnkuendigungType::setBIC()
     * @uses RetourenavisAnkuendigungType::setIBAN()
     * @param string $iD
     * @param int $retoureSupportID
     * @param \StructType\RetourePositionType[] $position
     * @param string $amtsgericht
     * @param string $handelsregisternummer
     * @param string $umsatzsteuerID
     * @param string $steuernummer
     * @param string $bankname
     * @param string $bIC
     * @param string $iBAN
     */
    public function __construct($iD = null, $retoureSupportID = null, array $position = array(), $amtsgericht = null, $handelsregisternummer = null, $umsatzsteuerID = null, $steuernummer = null, $bankname = null, $bIC = null, $iBAN = null)
    {
        $this
            ->setID($iD)
            ->setRetoureSupportID($retoureSupportID)
            ->setPosition($position)
            ->setAmtsgericht($amtsgericht)
            ->setHandelsregisternummer($handelsregisternummer)
            ->setUmsatzsteuerID($umsatzsteuerID)
            ->setSteuernummer($steuernummer)
            ->setBankname($bankname)
            ->setBIC($bIC)
            ->setIBAN($iBAN);
    }
    /**
     * Get ID value
     * @return string
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\RetourenavisAnkuendigungType
     */
    public function setID($iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get RetoureSupportID value
     * @return int
     */
    public function getRetoureSupportID()
    {
        return $this->RetoureSupportID;
    }
    /**
     * Set RetoureSupportID value
     * @param int $retoureSupportID
     * @return \StructType\RetourenavisAnkuendigungType
     */
    public function setRetoureSupportID($retoureSupportID = null)
    {
        $this->RetoureSupportID = $retoureSupportID;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\RetourePositionType[]|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @throws \InvalidArgumentException
     * @param \StructType\RetourePositionType[] $position
     * @return \StructType\RetourenavisAnkuendigungType
     */
    public function setPosition(array $position = array())
    {
        $this->Position = $position;
        return $this;
    }
    /**
     * Add item to Position value
     * @throws \InvalidArgumentException
     * @param \StructType\RetourePositionType $item
     * @return \StructType\RetourenavisAnkuendigungType
     */
    public function addToPosition(\StructType\RetourePositionType $item)
    {
        $this->Position[] = $item;
        return $this;
    }
    /**
     * Get Amtsgericht value
     * @return string|null
     */
    public function getAmtsgericht()
    {
        return $this->Amtsgericht;
    }
    /**
     * Set Amtsgericht value
     * @param string $amtsgericht
     * @return \StructType\RetourenavisAnkuendigungType
     */
    public function setAmtsgericht($amtsgericht = null)
    {
        $this->Amtsgericht = $amtsgericht;
        return $this;
    }
    /**
     * Get Handelsregisternummer value
     * @return string|null
     */
    public function getHandelsregisternummer()
    {
        return $this->Handelsregisternummer;
    }
    /**
     * Set Handelsregisternummer value
     * @param string $handelsregisternummer
     * @return \StructType\RetourenavisAnkuendigungType
     */
    public function setHandelsregisternummer($handelsregisternummer = null)
    {
        $this->Handelsregisternummer = $handelsregisternummer;
        return $this;
    }
    /**
     * Get UmsatzsteuerID value
     * @return string|null
     */
    public function getUmsatzsteuerID()
    {
        return $this->UmsatzsteuerID;
    }
    /**
     * Set UmsatzsteuerID value
     * @param string $umsatzsteuerID
     * @return \StructType\RetourenavisAnkuendigungType
     */
    public function setUmsatzsteuerID($umsatzsteuerID = null)
    {
        $this->UmsatzsteuerID = $umsatzsteuerID;
        return $this;
    }
    /**
     * Get Steuernummer value
     * @return string|null
     */
    public function getSteuernummer()
    {
        return $this->Steuernummer;
    }
    /**
     * Set Steuernummer value
     * @param string $steuernummer
     * @return \StructType\RetourenavisAnkuendigungType
     */
    public function setSteuernummer($steuernummer = null)
    {
        $this->Steuernummer = $steuernummer;
        return $this;
    }
    /**
     * Get Bankname value
     * @return string|null
     */
    public function getBankname()
    {
        return $this->Bankname;
    }
    /**
     * Set Bankname value
     * @param string $bankname
     * @return \StructType\RetourenavisAnkuendigungType
     */
    public function setBankname($bankname = null)
    {
        $this->Bankname = $bankname;
        return $this;
    }
    /**
     * Get BIC value
     * @return string|null
     */
    public function getBIC()
    {
        return $this->BIC;
    }
    /**
     * Set BIC value
     * @param string $bIC
     * @return \StructType\RetourenavisAnkuendigungType
     */
    public function setBIC($bIC = null)
    {
        $this->BIC = $bIC;
        return $this;
    }
    /**
     * Get IBAN value
     * @return string|null
     */
    public function getIBAN()
    {
        return $this->IBAN;
    }
    /**
     * Set IBAN value
     * @param string $iBAN
     * @return \StructType\RetourenavisAnkuendigungType
     */
    public function setIBAN($iBAN = null)
    {
        $this->IBAN = $iBAN;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RetourenavisAnkuendigungType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
