<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetourenavisAnkuendigungAntwort StructType
 * Meta informations extracted from the WSDL
 * - documentation: Antwort(en) zu einer RetourenAnkuendigung
 * @subpackage Structs
 */
class RetourenavisAnkuendigungAntwort extends AbstractStructBase
{
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - documentation: ID der Anfrage | eindeutige sich nie wiederholende ID des Webservicerequests. (Fuer Benutzung bei AF2 - Nachtraegliche Antwortabfrage fuer eine Bestellung) Datentyp GUID (Primaerschluessel)
     * - use: required
     * - length: 36
     * - pattern: ([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}
     * @var string
     */
    public $ID;
    /**
     * The RetoureSupportID
     * Meta informations extracted from the WSDL
     * - documentation: ausschliessliche Identifikation fuer Menschen! Support - keine technische Semantik Apo-Wawi vergibt diese; soll genuegend Selektiv sein
     * - use: required
     * - maxInclusive: 999999
     * - minInclusive: 1
     * @var int
     */
    public $RetoureSupportID;
    /**
     * The RetourenAnteil
     * Meta informations extracted from the WSDL
     * - maxOccurs: 15
     * @var \StructType\RetourenAnteil[]
     */
    public $RetourenAnteil;
    /**
     * Constructor method for RetourenavisAnkuendigungAntwort
     * @uses RetourenavisAnkuendigungAntwort::setID()
     * @uses RetourenavisAnkuendigungAntwort::setRetoureSupportID()
     * @uses RetourenavisAnkuendigungAntwort::setRetourenAnteil()
     * @param string $iD
     * @param int $retoureSupportID
     * @param \StructType\RetourenAnteil[] $retourenAnteil
     */
    public function __construct($iD = null, $retoureSupportID = null, array $retourenAnteil = array())
    {
        $this
            ->setID($iD)
            ->setRetoureSupportID($retoureSupportID)
            ->setRetourenAnteil($retourenAnteil);
    }
    /**
     * Get ID value
     * @return string
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\RetourenavisAnkuendigungAntwort
     */
    public function setID($iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get RetoureSupportID value
     * @return int
     */
    public function getRetoureSupportID()
    {
        return $this->RetoureSupportID;
    }
    /**
     * Set RetoureSupportID value
     * @param int $retoureSupportID
     * @return \StructType\RetourenavisAnkuendigungAntwort
     */
    public function setRetoureSupportID($retoureSupportID = null)
    {
        $this->RetoureSupportID = $retoureSupportID;
        return $this;
    }
    /**
     * Get RetourenAnteil value
     * @return \StructType\RetourenAnteil[]|null
     */
    public function getRetourenAnteil()
    {
        return $this->RetourenAnteil;
    }
    /**
     * Set RetourenAnteil value
     * @throws \InvalidArgumentException
     * @param \StructType\RetourenAnteil[] $retourenAnteil
     * @return \StructType\RetourenavisAnkuendigungAntwort
     */
    public function setRetourenAnteil(array $retourenAnteil = array())
    {
        $this->RetourenAnteil = $retourenAnteil;
        return $this;
    }
    /**
     * Add item to RetourenAnteil value
     * @throws \InvalidArgumentException
     * @param \StructType\RetourenAnteil $item
     * @return \StructType\RetourenavisAnkuendigungAntwort
     */
    public function addToRetourenAnteil(\StructType\RetourenAnteil $item)
    {
        $this->RetourenAnteil[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RetourenavisAnkuendigungAntwort
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
