<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Msv3FaultInfo StructType
 * @subpackage Structs
 */
class Msv3FaultInfo extends AbstractStructBase
{
    /**
     * The ErrorCode
     * Meta informations extracted from the WSDL
     * - maxLength: 5
     * - minLength: 1
     * @var string
     */
    public $ErrorCode;
    /**
     * The EndanwenderFehlertext
     * Meta informations extracted from the WSDL
     * - maxLength: 1024
     * - minLength: 1
     * @var string
     */
    public $EndanwenderFehlertext;
    /**
     * The TechnischerFehlertext
     * Meta informations extracted from the WSDL
     * - maxLength: 1024
     * - minLength: 1
     * @var string
     */
    public $TechnischerFehlertext;
    /**
     * Constructor method for Msv3FaultInfo
     * @uses Msv3FaultInfo::setErrorCode()
     * @uses Msv3FaultInfo::setEndanwenderFehlertext()
     * @uses Msv3FaultInfo::setTechnischerFehlertext()
     * @param string $errorCode
     * @param string $endanwenderFehlertext
     * @param string $technischerFehlertext
     */
    public function __construct($errorCode = null, $endanwenderFehlertext = null, $technischerFehlertext = null)
    {
        $this
            ->setErrorCode($errorCode)
            ->setEndanwenderFehlertext($endanwenderFehlertext)
            ->setTechnischerFehlertext($technischerFehlertext);
    }
    /**
     * Get ErrorCode value
     * @return string|null
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param string $errorCode
     * @return \StructType\Msv3FaultInfo
     */
    public function setErrorCode($errorCode = null)
    {
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Get EndanwenderFehlertext value
     * @return string|null
     */
    public function getEndanwenderFehlertext()
    {
        return $this->EndanwenderFehlertext;
    }
    /**
     * Set EndanwenderFehlertext value
     * @param string $endanwenderFehlertext
     * @return \StructType\Msv3FaultInfo
     */
    public function setEndanwenderFehlertext($endanwenderFehlertext = null)
    {
        $this->EndanwenderFehlertext = $endanwenderFehlertext;
        return $this;
    }
    /**
     * Get TechnischerFehlertext value
     * @return string|null
     */
    public function getTechnischerFehlertext()
    {
        return $this->TechnischerFehlertext;
    }
    /**
     * Set TechnischerFehlertext value
     * @param string $technischerFehlertext
     * @return \StructType\Msv3FaultInfo
     */
    public function setTechnischerFehlertext($technischerFehlertext = null)
    {
        $this->TechnischerFehlertext = $technischerFehlertext;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Msv3FaultInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
