<?php

namespace EnumType;

/**
 * This class stands for Liefervorgabe EnumType
 * @subpackage Enumerations
 */
class Liefervorgabe
{
    /**
     * Constant for value 'Normal'
     * @return string 'Normal'
     */
    const VALUE_NORMAL = 'Normal';
    /**
     * Constant for value 'MaxVerbund'
     * @return string 'MaxVerbund'
     */
    const VALUE_MAX_VERBUND = 'MaxVerbund';
    /**
     * Constant for value 'MaxNachlieferung'
     * @return string 'MaxNachlieferung'
     */
    const VALUE_MAX_NACHLIEFERUNG = 'MaxNachlieferung';
    /**
     * Constant for value 'MaxDispo'
     * @return string 'MaxDispo'
     */
    const VALUE_MAX_DISPO = 'MaxDispo';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NORMAL
     * @uses self::VALUE_MAX_VERBUND
     * @uses self::VALUE_MAX_NACHLIEFERUNG
     * @uses self::VALUE_MAX_DISPO
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NORMAL,
            self::VALUE_MAX_VERBUND,
            self::VALUE_MAX_NACHLIEFERUNG,
            self::VALUE_MAX_DISPO,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
