<?php

namespace EnumType;

/**
 * This class stands for BestellungRueckmeldungTyp EnumType
 * @subpackage Enumerations
 */
class BestellungRueckmeldungTyp
{
    /**
     * Constant for value 'Normal'
     * @return string 'Normal'
     */
    const VALUE_NORMAL = 'Normal';
    /**
     * Constant for value 'Verbund'
     * @return string 'Verbund'
     */
    const VALUE_VERBUND = 'Verbund';
    /**
     * Constant for value 'Nachlieferung'
     * @return string 'Nachlieferung'
     */
    const VALUE_NACHLIEFERUNG = 'Nachlieferung';
    /**
     * Constant for value 'Dispo'
     * @return string 'Dispo'
     */
    const VALUE_DISPO = 'Dispo';
    /**
     * Constant for value 'KeineLieferungAberNormalMoeglich'
     * @return string 'KeineLieferungAberNormalMoeglich'
     */
    const VALUE_KEINE_LIEFERUNG_ABER_NORMAL_MOEGLICH = 'KeineLieferungAberNormalMoeglich';
    /**
     * Constant for value 'KeineLieferungAberVerbundMoeglich'
     * @return string 'KeineLieferungAberVerbundMoeglich'
     */
    const VALUE_KEINE_LIEFERUNG_ABER_VERBUND_MOEGLICH = 'KeineLieferungAberVerbundMoeglich';
    /**
     * Constant for value 'KeineLieferungAberNachlieferungMoeglich'
     * @return string 'KeineLieferungAberNachlieferungMoeglich'
     */
    const VALUE_KEINE_LIEFERUNG_ABER_NACHLIEFERUNG_MOEGLICH = 'KeineLieferungAberNachlieferungMoeglich';
    /**
     * Constant for value 'KeineLieferungAberDispoMoeglich'
     * @return string 'KeineLieferungAberDispoMoeglich'
     */
    const VALUE_KEINE_LIEFERUNG_ABER_DISPO_MOEGLICH = 'KeineLieferungAberDispoMoeglich';
    /**
     * Constant for value 'NichtLieferbar'
     * @return string 'NichtLieferbar'
     */
    const VALUE_NICHT_LIEFERBAR = 'NichtLieferbar';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NORMAL
     * @uses self::VALUE_VERBUND
     * @uses self::VALUE_NACHLIEFERUNG
     * @uses self::VALUE_DISPO
     * @uses self::VALUE_KEINE_LIEFERUNG_ABER_NORMAL_MOEGLICH
     * @uses self::VALUE_KEINE_LIEFERUNG_ABER_VERBUND_MOEGLICH
     * @uses self::VALUE_KEINE_LIEFERUNG_ABER_NACHLIEFERUNG_MOEGLICH
     * @uses self::VALUE_KEINE_LIEFERUNG_ABER_DISPO_MOEGLICH
     * @uses self::VALUE_NICHT_LIEFERBAR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NORMAL,
            self::VALUE_VERBUND,
            self::VALUE_NACHLIEFERUNG,
            self::VALUE_DISPO,
            self::VALUE_KEINE_LIEFERUNG_ABER_NORMAL_MOEGLICH,
            self::VALUE_KEINE_LIEFERUNG_ABER_VERBUND_MOEGLICH,
            self::VALUE_KEINE_LIEFERUNG_ABER_NACHLIEFERUNG_MOEGLICH,
            self::VALUE_KEINE_LIEFERUNG_ABER_DISPO_MOEGLICH,
            self::VALUE_NICHT_LIEFERBAR,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
