<?php

namespace EnumType;

/**
 * This class stands for Auftragsart EnumType
 * @subpackage Enumerations
 */
class Auftragsart
{
    /**
     * Constant for value 'NORMAL'
     * @return string 'NORMAL'
     */
    const VALUE_NORMAL = 'NORMAL';
    /**
     * Constant for value 'STAPEL'
     * @return string 'STAPEL'
     */
    const VALUE_STAPEL = 'STAPEL';
    /**
     * Constant for value 'SONDER'
     * @return string 'SONDER'
     */
    const VALUE_SONDER = 'SONDER';
    /**
     * Constant for value 'VERSAND'
     * @return string 'VERSAND'
     */
    const VALUE_VERSAND = 'VERSAND';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NORMAL
     * @uses self::VALUE_STAPEL
     * @uses self::VALUE_SONDER
     * @uses self::VALUE_VERSAND
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NORMAL,
            self::VALUE_STAPEL,
            self::VALUE_SONDER,
            self::VALUE_VERSAND,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
