<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VertragsdatenAntwort StructType
 * Meta informations extracted from the WSDL
 * - documentation: Vertragsdaten fuer MSV3 inklusive Sondertage
 * @subpackage Structs
 */
class VertragsdatenAntwort extends AbstractStructBase
{
    /**
     * The AutomatischerAbruf
     * Meta informations extracted from the WSDL
     * - documentation: Angabe, ob der Vertragsdatenabruf aus dem automatischen taeglichen Abruf erfolgt ist oder manuell ausgeloest wurde. Der Wert wird in der Anfrage mitgesendet und an dieser Stelle in die Antwort uebernommen.
     * - use: required
     * @var bool
     */
    public $AutomatischerAbruf;
    /**
     * The KundenKennung
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $KundenKennung;
    /**
     * The Bestellfenster
     * Meta informations extracted from the WSDL
     * - maxOccurs: 999
     * @var \StructType\VertragsdatenBestellfenster[]
     */
    public $Bestellfenster;
    /**
     * The AuftragsartNormal
     * @var \StructType\VertragsdatenAuftragsartNormal
     */
    public $AuftragsartNormal;
    /**
     * The AuftragsartStapel
     * @var \StructType\VertragsdatenAuftragsart
     */
    public $AuftragsartStapel;
    /**
     * The AuftragsartSonder
     * @var \StructType\VertragsdatenAuftragsart
     */
    public $AuftragsartSonder;
    /**
     * The AuftragsartVersand
     * @var \StructType\VertragsdatenAuftragsartVersand
     */
    public $AuftragsartVersand;
    /**
     * The Substitutionsvereinbarung
     * @var bool
     */
    public $Substitutionsvereinbarung;
    /**
     * The VerfuegbarkeitEinzelnSpezifischeRueckmeldungVereinbart
     * @var bool
     */
    public $VerfuegbarkeitEinzelnSpezifischeRueckmeldungVereinbart;
    /**
     * The VerfuegbarkeitBulkVereinbart
     * @var bool
     */
    public $VerfuegbarkeitBulkVereinbart;
    /**
     * The RuecknahmeangebotVereinbart
     * @var bool
     */
    public $RuecknahmeangebotVereinbart;
    /**
     * The Sondertag
     * Meta informations extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\TypSondertag[]
     */
    public $Sondertag;
    /**
     * Constructor method for VertragsdatenAntwort
     * @uses VertragsdatenAntwort::setAutomatischerAbruf()
     * @uses VertragsdatenAntwort::setKundenKennung()
     * @uses VertragsdatenAntwort::setBestellfenster()
     * @uses VertragsdatenAntwort::setAuftragsartNormal()
     * @uses VertragsdatenAntwort::setAuftragsartStapel()
     * @uses VertragsdatenAntwort::setAuftragsartSonder()
     * @uses VertragsdatenAntwort::setAuftragsartVersand()
     * @uses VertragsdatenAntwort::setSubstitutionsvereinbarung()
     * @uses VertragsdatenAntwort::setVerfuegbarkeitEinzelnSpezifischeRueckmeldungVereinbart()
     * @uses VertragsdatenAntwort::setVerfuegbarkeitBulkVereinbart()
     * @uses VertragsdatenAntwort::setRuecknahmeangebotVereinbart()
     * @uses VertragsdatenAntwort::setSondertag()
     * @param bool $automatischerAbruf
     * @param string $kundenKennung
     * @param \StructType\VertragsdatenBestellfenster[] $bestellfenster
     * @param \StructType\VertragsdatenAuftragsartNormal $auftragsartNormal
     * @param \StructType\VertragsdatenAuftragsart $auftragsartStapel
     * @param \StructType\VertragsdatenAuftragsart $auftragsartSonder
     * @param \StructType\VertragsdatenAuftragsartVersand $auftragsartVersand
     * @param bool $substitutionsvereinbarung
     * @param bool $verfuegbarkeitEinzelnSpezifischeRueckmeldungVereinbart
     * @param bool $verfuegbarkeitBulkVereinbart
     * @param bool $ruecknahmeangebotVereinbart
     * @param \StructType\TypSondertag[] $sondertag
     */
    public function __construct($automatischerAbruf = null, $kundenKennung = null, array $bestellfenster = array(), \StructType\VertragsdatenAuftragsartNormal $auftragsartNormal = null, \StructType\VertragsdatenAuftragsart $auftragsartStapel = null, \StructType\VertragsdatenAuftragsart $auftragsartSonder = null, \StructType\VertragsdatenAuftragsartVersand $auftragsartVersand = null, $substitutionsvereinbarung = null, $verfuegbarkeitEinzelnSpezifischeRueckmeldungVereinbart = null, $verfuegbarkeitBulkVereinbart = null, $ruecknahmeangebotVereinbart = null, array $sondertag = array())
    {
        $this
            ->setAutomatischerAbruf($automatischerAbruf)
            ->setKundenKennung($kundenKennung)
            ->setBestellfenster($bestellfenster)
            ->setAuftragsartNormal($auftragsartNormal)
            ->setAuftragsartStapel($auftragsartStapel)
            ->setAuftragsartSonder($auftragsartSonder)
            ->setAuftragsartVersand($auftragsartVersand)
            ->setSubstitutionsvereinbarung($substitutionsvereinbarung)
            ->setVerfuegbarkeitEinzelnSpezifischeRueckmeldungVereinbart($verfuegbarkeitEinzelnSpezifischeRueckmeldungVereinbart)
            ->setVerfuegbarkeitBulkVereinbart($verfuegbarkeitBulkVereinbart)
            ->setRuecknahmeangebotVereinbart($ruecknahmeangebotVereinbart)
            ->setSondertag($sondertag);
    }
    /**
     * Get AutomatischerAbruf value
     * @return bool
     */
    public function getAutomatischerAbruf()
    {
        return $this->AutomatischerAbruf;
    }
    /**
     * Set AutomatischerAbruf value
     * @param bool $automatischerAbruf
     * @return \StructType\VertragsdatenAntwort
     */
    public function setAutomatischerAbruf($automatischerAbruf = null)
    {
        $this->AutomatischerAbruf = $automatischerAbruf;
        return $this;
    }
    /**
     * Get KundenKennung value
     * @return string
     */
    public function getKundenKennung()
    {
        return $this->KundenKennung;
    }
    /**
     * Set KundenKennung value
     * @param string $kundenKennung
     * @return \StructType\VertragsdatenAntwort
     */
    public function setKundenKennung($kundenKennung = null)
    {
        $this->KundenKennung = $kundenKennung;
        return $this;
    }
    /**
     * Get Bestellfenster value
     * @return \StructType\VertragsdatenBestellfenster[]|null
     */
    public function getBestellfenster()
    {
        return $this->Bestellfenster;
    }
    /**
     * Set Bestellfenster value
     * @throws \InvalidArgumentException
     * @param \StructType\VertragsdatenBestellfenster[] $bestellfenster
     * @return \StructType\VertragsdatenAntwort
     */
    public function setBestellfenster(array $bestellfenster = array())
    {
        $this->Bestellfenster = $bestellfenster;
        return $this;
    }
    /**
     * Add item to Bestellfenster value
     * @throws \InvalidArgumentException
     * @param \StructType\VertragsdatenBestellfenster $item
     * @return \StructType\VertragsdatenAntwort
     */
    public function addToBestellfenster(\StructType\VertragsdatenBestellfenster $item)
    {
        $this->Bestellfenster[] = $item;
        return $this;
    }
    /**
     * Get AuftragsartNormal value
     * @return \StructType\VertragsdatenAuftragsartNormal|null
     */
    public function getAuftragsartNormal()
    {
        return $this->AuftragsartNormal;
    }
    /**
     * Set AuftragsartNormal value
     * @param \StructType\VertragsdatenAuftragsartNormal $auftragsartNormal
     * @return \StructType\VertragsdatenAntwort
     */
    public function setAuftragsartNormal(\StructType\VertragsdatenAuftragsartNormal $auftragsartNormal = null)
    {
        $this->AuftragsartNormal = $auftragsartNormal;
        return $this;
    }
    /**
     * Get AuftragsartStapel value
     * @return \StructType\VertragsdatenAuftragsart|null
     */
    public function getAuftragsartStapel()
    {
        return $this->AuftragsartStapel;
    }
    /**
     * Set AuftragsartStapel value
     * @param \StructType\VertragsdatenAuftragsart $auftragsartStapel
     * @return \StructType\VertragsdatenAntwort
     */
    public function setAuftragsartStapel(\StructType\VertragsdatenAuftragsart $auftragsartStapel = null)
    {
        $this->AuftragsartStapel = $auftragsartStapel;
        return $this;
    }
    /**
     * Get AuftragsartSonder value
     * @return \StructType\VertragsdatenAuftragsart|null
     */
    public function getAuftragsartSonder()
    {
        return $this->AuftragsartSonder;
    }
    /**
     * Set AuftragsartSonder value
     * @param \StructType\VertragsdatenAuftragsart $auftragsartSonder
     * @return \StructType\VertragsdatenAntwort
     */
    public function setAuftragsartSonder(\StructType\VertragsdatenAuftragsart $auftragsartSonder = null)
    {
        $this->AuftragsartSonder = $auftragsartSonder;
        return $this;
    }
    /**
     * Get AuftragsartVersand value
     * @return \StructType\VertragsdatenAuftragsartVersand|null
     */
    public function getAuftragsartVersand()
    {
        return $this->AuftragsartVersand;
    }
    /**
     * Set AuftragsartVersand value
     * @param \StructType\VertragsdatenAuftragsartVersand $auftragsartVersand
     * @return \StructType\VertragsdatenAntwort
     */
    public function setAuftragsartVersand(\StructType\VertragsdatenAuftragsartVersand $auftragsartVersand = null)
    {
        $this->AuftragsartVersand = $auftragsartVersand;
        return $this;
    }
    /**
     * Get Substitutionsvereinbarung value
     * @return bool|null
     */
    public function getSubstitutionsvereinbarung()
    {
        return $this->Substitutionsvereinbarung;
    }
    /**
     * Set Substitutionsvereinbarung value
     * @param bool $substitutionsvereinbarung
     * @return \StructType\VertragsdatenAntwort
     */
    public function setSubstitutionsvereinbarung($substitutionsvereinbarung = null)
    {
        $this->Substitutionsvereinbarung = $substitutionsvereinbarung;
        return $this;
    }
    /**
     * Get VerfuegbarkeitEinzelnSpezifischeRueckmeldungVereinbart value
     * @return bool|null
     */
    public function getVerfuegbarkeitEinzelnSpezifischeRueckmeldungVereinbart()
    {
        return $this->VerfuegbarkeitEinzelnSpezifischeRueckmeldungVereinbart;
    }
    /**
     * Set VerfuegbarkeitEinzelnSpezifischeRueckmeldungVereinbart value
     * @param bool $verfuegbarkeitEinzelnSpezifischeRueckmeldungVereinbart
     * @return \StructType\VertragsdatenAntwort
     */
    public function setVerfuegbarkeitEinzelnSpezifischeRueckmeldungVereinbart($verfuegbarkeitEinzelnSpezifischeRueckmeldungVereinbart = null)
    {
        $this->VerfuegbarkeitEinzelnSpezifischeRueckmeldungVereinbart = $verfuegbarkeitEinzelnSpezifischeRueckmeldungVereinbart;
        return $this;
    }
    /**
     * Get VerfuegbarkeitBulkVereinbart value
     * @return bool|null
     */
    public function getVerfuegbarkeitBulkVereinbart()
    {
        return $this->VerfuegbarkeitBulkVereinbart;
    }
    /**
     * Set VerfuegbarkeitBulkVereinbart value
     * @param bool $verfuegbarkeitBulkVereinbart
     * @return \StructType\VertragsdatenAntwort
     */
    public function setVerfuegbarkeitBulkVereinbart($verfuegbarkeitBulkVereinbart = null)
    {
        $this->VerfuegbarkeitBulkVereinbart = $verfuegbarkeitBulkVereinbart;
        return $this;
    }
    /**
     * Get RuecknahmeangebotVereinbart value
     * @return bool|null
     */
    public function getRuecknahmeangebotVereinbart()
    {
        return $this->RuecknahmeangebotVereinbart;
    }
    /**
     * Set RuecknahmeangebotVereinbart value
     * @param bool $ruecknahmeangebotVereinbart
     * @return \StructType\VertragsdatenAntwort
     */
    public function setRuecknahmeangebotVereinbart($ruecknahmeangebotVereinbart = null)
    {
        $this->RuecknahmeangebotVereinbart = $ruecknahmeangebotVereinbart;
        return $this;
    }
    /**
     * Get Sondertag value
     * @return \StructType\TypSondertag[]|null
     */
    public function getSondertag()
    {
        return $this->Sondertag;
    }
    /**
     * Set Sondertag value
     * @throws \InvalidArgumentException
     * @param \StructType\TypSondertag[] $sondertag
     * @return \StructType\VertragsdatenAntwort
     */
    public function setSondertag(array $sondertag = array())
    {
        $this->Sondertag = $sondertag;
        return $this;
    }
    /**
     * Add item to Sondertag value
     * @throws \InvalidArgumentException
     * @param \StructType\TypSondertag $item
     * @return \StructType\VertragsdatenAntwort
     */
    public function addToSondertag(\StructType\TypSondertag $item)
    {
        $this->Sondertag[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VertragsdatenAntwort
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
