<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetourenavisAnfrageType StructType
 * Meta informations extracted from the WSDL
 * - documentation: unverbind. Anfrage zur Beurteilung durch GH
 * @subpackage Structs
 */
class RetourenavisAnfrageType extends AbstractStructBase
{
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - documentation: Vom System zu vergebende eindeutige ID zur Referenzierung durch den GH (GUID) | eindeutige sich nie wiederholende ID des Webservicerequests. (Fuer Benutzung bei AF2 - Nachtraegliche Antwortabfrage fuer eine Bestellung) Datentyp GUID
     * (Primaerschluessel)
     * - use: required
     * - length: 36
     * - pattern: ([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}
     * @var string
     */
    public $ID;
    /**
     * The RetoureSupportID
     * Meta informations extracted from the WSDL
     * - documentation: Ausschliessliche Identifikation fuer Menschen! Dient fuer Rueckfragen beim GH (optional Anzeige auf GUI kein Andruck) - keine technische Semantik Apo-Wawi vergibt diese; soll genuegend Selektiv sein
     * - use: required
     * - maxInclusive: 999999
     * - minInclusive: 1
     * @var int
     */
    public $RetoureSupportID;
    /**
     * The Position
     * Meta informations extracted from the WSDL
     * - maxOccurs: 999
     * @var \StructType\RetourePositionType[]
     */
    public $Position;
    /**
     * Constructor method for RetourenavisAnfrageType
     * @uses RetourenavisAnfrageType::setID()
     * @uses RetourenavisAnfrageType::setRetoureSupportID()
     * @uses RetourenavisAnfrageType::setPosition()
     * @param string $iD
     * @param int $retoureSupportID
     * @param \StructType\RetourePositionType[] $position
     */
    public function __construct($iD = null, $retoureSupportID = null, array $position = array())
    {
        $this
            ->setID($iD)
            ->setRetoureSupportID($retoureSupportID)
            ->setPosition($position);
    }
    /**
     * Get ID value
     * @return string
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\RetourenavisAnfrageType
     */
    public function setID($iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get RetoureSupportID value
     * @return int
     */
    public function getRetoureSupportID()
    {
        return $this->RetoureSupportID;
    }
    /**
     * Set RetoureSupportID value
     * @param int $retoureSupportID
     * @return \StructType\RetourenavisAnfrageType
     */
    public function setRetoureSupportID($retoureSupportID = null)
    {
        $this->RetoureSupportID = $retoureSupportID;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\RetourePositionType[]|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @throws \InvalidArgumentException
     * @param \StructType\RetourePositionType[] $position
     * @return \StructType\RetourenavisAnfrageType
     */
    public function setPosition(array $position = array())
    {
        $this->Position = $position;
        return $this;
    }
    /**
     * Add item to Position value
     * @throws \InvalidArgumentException
     * @param \StructType\RetourePositionType $item
     * @return \StructType\RetourenavisAnfrageType
     */
    public function addToPosition(\StructType\RetourePositionType $item)
    {
        $this->Position[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RetourenavisAnfrageType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
