<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetourenavisAnfrageAntwort StructType
 * Meta informations extracted from the WSDL
 * - documentation: Antwort(en) zu einer RetourenAnfrage
 * @subpackage Structs
 */
class RetourenavisAnfrageAntwort extends AbstractStructBase
{
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - documentation: ID der Anfrage | eindeutige sich nie wiederholende ID des Webservicerequests. (Fuer Benutzung bei AF2 - Nachtraegliche Antwortabfrage fuer eine Bestellung) Datentyp GUID (Primaerschluessel)
     * - use: required
     * - length: 36
     * - pattern: ([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}
     * @var string
     */
    public $ID;
    /**
     * The RetoureSupportID
     * Meta informations extracted from the WSDL
     * - documentation: ausschliessliche Identifikation fuer Menschen! Support (optional Anzeige auf GUI kein Andruck) - keine technische Semantik Apo-Wawi vergibt diese; soll genuegend Selektiv sein
     * - use: required
     * - maxInclusive: 999999
     * - minInclusive: 1
     * @var int
     */
    public $RetoureSupportID;
    /**
     * The Position
     * Meta informations extracted from the WSDL
     * - maxOccurs: 999
     * @var \StructType\Position[]
     */
    public $Position;
    /**
     * Constructor method for RetourenavisAnfrageAntwort
     * @uses RetourenavisAnfrageAntwort::setID()
     * @uses RetourenavisAnfrageAntwort::setRetoureSupportID()
     * @uses RetourenavisAnfrageAntwort::setPosition()
     * @param string $iD
     * @param int $retoureSupportID
     * @param \StructType\Position[] $position
     */
    public function __construct($iD = null, $retoureSupportID = null, array $position = array())
    {
        $this
            ->setID($iD)
            ->setRetoureSupportID($retoureSupportID)
            ->setPosition($position);
    }
    /**
     * Get ID value
     * @return string
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\RetourenavisAnfrageAntwort
     */
    public function setID($iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get RetoureSupportID value
     * @return int
     */
    public function getRetoureSupportID()
    {
        return $this->RetoureSupportID;
    }
    /**
     * Set RetoureSupportID value
     * @param int $retoureSupportID
     * @return \StructType\RetourenavisAnfrageAntwort
     */
    public function setRetoureSupportID($retoureSupportID = null)
    {
        $this->RetoureSupportID = $retoureSupportID;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\Position[]|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @throws \InvalidArgumentException
     * @param \StructType\Position[] $position
     * @return \StructType\RetourenavisAnfrageAntwort
     */
    public function setPosition(array $position = array())
    {
        $this->Position = $position;
        return $this;
    }
    /**
     * Add item to Position value
     * @throws \InvalidArgumentException
     * @param \StructType\Position $item
     * @return \StructType\RetourenavisAnfrageAntwort
     */
    public function addToPosition(\StructType\Position $item)
    {
        $this->Position[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RetourenavisAnfrageAntwort
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
