<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetourenAnteil StructType
 * @subpackage Structs
 */
class RetourenAnteil extends AbstractStructBase
{
    /**
     * The RetourenAnteilTyp
     * Meta informations extracted from the WSDL
     * - documentation: Ja (Retoure akzeptiert), Nein (LS unbekannt, PZN nicht im LS enthalten, keine Ruecknahme, Rueckgabefrist ueberschritten)
     * - use: required
     * @var string
     */
    public $RetourenAnteilTyp;
    /**
     * The Position
     * Meta informations extracted from the WSDL
     * - maxOccurs: 999
     * @var \StructType\Position[]
     */
    public $Position;
    /**
     * The GHReferenzID
     * @var string
     */
    public $GHReferenzID;
    /**
     * The DokumentID
     * Meta informations extracted from the WSDL
     * - documentation: optional ID eines PDF-Retourenscheins. Wenn nicht angegeben, generiert der Client einen Retourenschein selbst. Die Entscheidung, wer den Retourenbeleg druckt, muss ueber alle Touranteile gleich sein. | eindeutige sich nie
     * wiederholende ID des Webservicerequests. (Fuer Benutzung bei AF2 - Nachtraegliche Antwortabfrage fuer eine Bestellung) Datentyp GUID (Primaerschluessel)
     * - length: 36
     * - pattern: ([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}
     * @var string
     */
    public $DokumentID;
    /**
     * The Abholzeitpunkt
     * Meta informations extracted from the WSDL
     * - documentation: Voraussichtlich! z.B. 25.05.2015 14.00 Uhr. Datum+Uhrzeit der Abholung in der Apotheke. Sobald mind. eine Position akzeptiert wird, muss entweder Abholzeitpunkt oder die Tour muessen gefuellt sein, sobald eine Retourenmenge
     * akzeptiert wird.
     * - use: optional
     * @var string
     */
    public $Abholzeitpunkt;
    /**
     * The Tour
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Tour;
    /**
     * Constructor method for RetourenAnteil
     * @uses RetourenAnteil::setRetourenAnteilTyp()
     * @uses RetourenAnteil::setPosition()
     * @uses RetourenAnteil::setGHReferenzID()
     * @uses RetourenAnteil::setDokumentID()
     * @uses RetourenAnteil::setAbholzeitpunkt()
     * @uses RetourenAnteil::setTour()
     * @param string $retourenAnteilTyp
     * @param \StructType\Position[] $position
     * @param string $gHReferenzID
     * @param string $dokumentID
     * @param string $abholzeitpunkt
     * @param string $tour
     */
    public function __construct($retourenAnteilTyp = null, array $position = array(), $gHReferenzID = null, $dokumentID = null, $abholzeitpunkt = null, $tour = null)
    {
        $this
            ->setRetourenAnteilTyp($retourenAnteilTyp)
            ->setPosition($position)
            ->setGHReferenzID($gHReferenzID)
            ->setDokumentID($dokumentID)
            ->setAbholzeitpunkt($abholzeitpunkt)
            ->setTour($tour);
    }
    /**
     * Get RetourenAnteilTyp value
     * @return string
     */
    public function getRetourenAnteilTyp()
    {
        return $this->RetourenAnteilTyp;
    }
    /**
     * Set RetourenAnteilTyp value
     * @uses \EnumType\RetourenAnteilTypType::valueIsValid()
     * @uses \EnumType\RetourenAnteilTypType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $retourenAnteilTyp
     * @return \StructType\RetourenAnteil
     */
    public function setRetourenAnteilTyp($retourenAnteilTyp = null)
    {
        $this->RetourenAnteilTyp = $retourenAnteilTyp;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\Position[]|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @throws \InvalidArgumentException
     * @param \StructType\Position[] $position
     * @return \StructType\RetourenAnteil
     */
    public function setPosition(array $position = array())
    {
        $this->Position = $position;
        return $this;
    }
    /**
     * Add item to Position value
     * @throws \InvalidArgumentException
     * @param \StructType\Position $item
     * @return \StructType\RetourenAnteil
     */
    public function addToPosition(\StructType\Position $item)
    {
        $this->Position[] = $item;
        return $this;
    }
    /**
     * Get GHReferenzID value
     * @return string|null
     */
    public function getGHReferenzID()
    {
        return $this->GHReferenzID;
    }
    /**
     * Set GHReferenzID value
     * @param string $gHReferenzID
     * @return \StructType\RetourenAnteil
     */
    public function setGHReferenzID($gHReferenzID = null)
    {
        $this->GHReferenzID = $gHReferenzID;
        return $this;
    }
    /**
     * Get DokumentID value
     * @return string|null
     */
    public function getDokumentID()
    {
        return $this->DokumentID;
    }
    /**
     * Set DokumentID value
     * @param string $dokumentID
     * @return \StructType\RetourenAnteil
     */
    public function setDokumentID($dokumentID = null)
    {
        $this->DokumentID = $dokumentID;
        return $this;
    }
    /**
     * Get Abholzeitpunkt value
     * @return string|null
     */
    public function getAbholzeitpunkt()
    {
        return $this->Abholzeitpunkt;
    }
    /**
     * Set Abholzeitpunkt value
     * @param string $abholzeitpunkt
     * @return \StructType\RetourenAnteil
     */
    public function setAbholzeitpunkt($abholzeitpunkt = null)
    {
        $this->Abholzeitpunkt = $abholzeitpunkt;
        return $this;
    }
    /**
     * Get Tour value
     * @return string|null
     */
    public function getTour()
    {
        return $this->Tour;
    }
    /**
     * Set Tour value
     * @param string $tour
     * @return \StructType\RetourenAnteil
     */
    public function setTour($tour = null)
    {
        $this->Tour = $tour;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RetourenAnteil
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
