<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LieferavisBestaetigenType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Bestaetigung des Lieferavis-Empfangs
 * @subpackage Structs
 */
class LieferavisBestaetigenType extends AbstractStructBase
{
    /**
     * The Lieferscheinnummer
     * Meta informations extracted from the WSDL
     * - documentation: fachlich und technischer PK Nummer vom Papierlieferschein der in der Apotheke verarbeitet wurde
     * - maxOccurs: 999
     * - maxLength: 30
     * - minLength: 1
     * - pattern: [a-zA-Z0-9#+\*[:slash:]\-_]*
     * @var string[]
     */
    public $Lieferscheinnummer;
    /**
     * Constructor method for LieferavisBestaetigenType
     * @uses LieferavisBestaetigenType::setLieferscheinnummer()
     * @param string[] $lieferscheinnummer
     */
    public function __construct(array $lieferscheinnummer = array())
    {
        $this
            ->setLieferscheinnummer($lieferscheinnummer);
    }
    /**
     * Get Lieferscheinnummer value
     * @return string[]|null
     */
    public function getLieferscheinnummer()
    {
        return $this->Lieferscheinnummer;
    }
    /**
     * Set Lieferscheinnummer value
     * @throws \InvalidArgumentException
     * @param string[] $lieferscheinnummer
     * @return \StructType\LieferavisBestaetigenType
     */
    public function setLieferscheinnummer(array $lieferscheinnummer = array())
    {
        $this->Lieferscheinnummer = $lieferscheinnummer;
        return $this;
    }
    /**
     * Add item to Lieferscheinnummer value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\LieferavisBestaetigenType
     */
    public function addToLieferscheinnummer($item)
    {
        $this->Lieferscheinnummer[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LieferavisBestaetigenType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
