<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LieferavisAbfrageHistAbfrage StructType
 * @subpackage Structs
 */
class LieferavisAbfrageHistAbfrage extends AbstractStructBase
{
    /**
     * The Lieferscheinnummer
     * Meta informations extracted from the WSDL
     * - documentation: fachlich und technischer PK Nummer vom Papierlieferschein
     * - use: optional
     * - maxLength: 30
     * - minLength: 1
     * - pattern: [a-zA-Z0-9#+\*[:slash:]\-_]*
     * @var string
     */
    public $Lieferscheinnummer;
    /**
     * The BarcodeReferenz
     * Meta informations extracted from the WSDL
     * - documentation: fuer Abscannen mit Praefix! (1D oder 2D)
     * - use: optional
     * - maxLength: 30
     * - minLength: 1
     * - pattern: [0-9]*[\*+#_\?][a-zA-Z0-9#+\*[:slash:]\-_\?]*
     * @var string
     */
    public $BarcodeReferenz;
    /**
     * Constructor method for LieferavisAbfrageHistAbfrage
     * @uses LieferavisAbfrageHistAbfrage::setLieferscheinnummer()
     * @uses LieferavisAbfrageHistAbfrage::setBarcodeReferenz()
     * @param string $lieferscheinnummer
     * @param string $barcodeReferenz
     */
    public function __construct($lieferscheinnummer = null, $barcodeReferenz = null)
    {
        $this
            ->setLieferscheinnummer($lieferscheinnummer)
            ->setBarcodeReferenz($barcodeReferenz);
    }
    /**
     * Get Lieferscheinnummer value
     * @return string|null
     */
    public function getLieferscheinnummer()
    {
        return $this->Lieferscheinnummer;
    }
    /**
     * Set Lieferscheinnummer value
     * @param string $lieferscheinnummer
     * @return \StructType\LieferavisAbfrageHistAbfrage
     */
    public function setLieferscheinnummer($lieferscheinnummer = null)
    {
        $this->Lieferscheinnummer = $lieferscheinnummer;
        return $this;
    }
    /**
     * Get BarcodeReferenz value
     * @return string|null
     */
    public function getBarcodeReferenz()
    {
        return $this->BarcodeReferenz;
    }
    /**
     * Set BarcodeReferenz value
     * @param string $barcodeReferenz
     * @return \StructType\LieferavisAbfrageHistAbfrage
     */
    public function setBarcodeReferenz($barcodeReferenz = null)
    {
        $this->BarcodeReferenz = $barcodeReferenz;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LieferavisAbfrageHistAbfrage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
