<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Fehlmenge StructType
 * Meta informations extracted from the WSDL
 * - documentation: Differenz zwischen bei Bestellung zu liefernd zurueckgemeldet und nicht geliefert (nachtraeglicher Lagerdefekt beim GH) Bei dieser Menge darf davon ausgegangen werden, dass eine spaetere (Nach)Lieferung NICHT erfolgt
 * @subpackage Structs
 */
class Fehlmenge extends AbstractStructBase
{
    /**
     * The Menge
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Menge;
    /**
     * The AuftragsID
     * Meta informations extracted from the WSDL
     * - documentation: optional nur fuer NICHT-MSV3Bestellungen (Telefon, Fax, MSV2) Die Befuellung des Feldes erfolgt nur bei eindeutiger Zuordnung – an-dernfalls soll das Feld nicht befuellt werden (Bsp.: Zusammenfueh-rung…) | eindeutige sich nie
     * wiederholende ID des Webservicerequests. (Fuer Benutzung bei AF2 - Nachtraegliche Antwortabfrage fuer eine Bestellung) Datentyp GUID (Primaerschluessel)
     * - length: 36
     * - pattern: ([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}
     * @var string
     */
    public $AuftragsID;
    /**
     * Constructor method for Fehlmenge
     * @uses Fehlmenge::setMenge()
     * @uses Fehlmenge::setAuftragsID()
     * @param string $menge
     * @param string $auftragsID
     */
    public function __construct($menge = null, $auftragsID = null)
    {
        $this
            ->setMenge($menge)
            ->setAuftragsID($auftragsID);
    }
    /**
     * Get Menge value
     * @return string
     */
    public function getMenge()
    {
        return $this->Menge;
    }
    /**
     * Set Menge value
     * @param string $menge
     * @return \StructType\Fehlmenge
     */
    public function setMenge($menge = null)
    {
        $this->Menge = $menge;
        return $this;
    }
    /**
     * Get AuftragsID value
     * @return string|null
     */
    public function getAuftragsID()
    {
        return $this->AuftragsID;
    }
    /**
     * Set AuftragsID value
     * @param string $auftragsID
     * @return \StructType\Fehlmenge
     */
    public function setAuftragsID($auftragsID = null)
    {
        $this->AuftragsID = $auftragsID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Fehlmenge
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
