<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DokumentAbfragenType StructType
 * Meta informations extracted from the WSDL
 * - documentation: PDF Dokumente fuer Lieveravis und Retourenavis abfragen
 * @subpackage Structs
 */
class DokumentAbfragenType extends AbstractStructBase
{
    /**
     * The DokumentId
     * Meta informations extracted from the WSDL
     * - use: required
     * - documentation: eindeutige sich nie wiederholende ID des Webservicerequests. (Fuer Benutzung bei AF2 - Nachtraegliche Antwortabfrage fuer eine Bestellung) Datentyp GUID (Primaerschluessel)
     * - length: 36
     * - pattern: ([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}
     * @var string
     */
    public $DokumentId;
    /**
     * Constructor method for DokumentAbfragenType
     * @uses DokumentAbfragenType::setDokumentId()
     * @param string $dokumentId
     */
    public function __construct($dokumentId = null)
    {
        $this
            ->setDokumentId($dokumentId);
    }
    /**
     * Get DokumentId value
     * @return string
     */
    public function getDokumentId()
    {
        return $this->DokumentId;
    }
    /**
     * Set DokumentId value
     * @param string $dokumentId
     * @return \StructType\DokumentAbfragenType
     */
    public function setDokumentId($dokumentId = null)
    {
        $this->DokumentId = $dokumentId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DokumentAbfragenType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
