<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BestellungAuftrag StructType
 * Meta informations extracted from the WSDL
 * - documentation: Reihenfolge in der Antwort muss gleich sein! aber maximal 1000 Positionen in der gesamten Bestellung!
 * @subpackage Structs
 */
class BestellungAuftrag extends AbstractStructBase
{
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - use: required
     * - documentation: eindeutige sich nie wiederholende ID des Webservicerequests. (Fuer Benutzung bei AF2 - Nachtraegliche Antwortabfrage fuer eine Bestellung) Datentyp GUID (Primaerschluessel)
     * - length: 36
     * - pattern: ([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}
     * @var string
     */
    public $Id;
    /**
     * The Auftragsart
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Auftragsart;
    /**
     * The Auftragskennung
     * Meta informations extracted from the WSDL
     * - documentation: eine von 4 vordefinierten oder eine freie kennung | Typ fuer alle auf Gebinden und Papier aufgedruckten Kennungen
     * - use: required
     * - pattern: [A-Z0-9+\-_]{1,20}
     * @var string
     */
    public $Auftragskennung;
    /**
     * The AuftragsSupportID
     * Meta informations extracted from the WSDL
     * - documentation: ausschliessliche Identifikation fuer Menschen! Support (optional Anzeige auf GUI kein Andruck) - keine technische Semantik Apo-Wawi vergibt diese; soll genuegend Selektiv sein
     * - use: required
     * - maxInclusive: 999999
     * - minInclusive: 1
     * @var int
     */
    public $AuftragsSupportID;
    /**
     * The Positionen
     * Meta informations extracted from the WSDL
     * - documentation: Reihenfolge (bez PZN) in der Antwort darf beliebig sein! keine doppelten PZNs innerhalb eines Auftrags erlaubt (in gesamter Bestellung schon).
     * - maxOccurs: 1000
     * @var \StructType\BestellungPosition[]
     */
    public $Positionen;
    /**
     * The GebindeId
     * Meta informations extracted from the WSDL
     * - documentation: bei Auftragsart=Versand Pflicht sonst nicht erlaubt | Typ fuer alle auf Gebinden und Papier aufgedruckten Kennungen
     * - use: optional
     * - pattern: [A-Z0-9+\-_]{1,20}
     * @var string
     */
    public $GebindeId;
    /**
     * Constructor method for BestellungAuftrag
     * @uses BestellungAuftrag::setId()
     * @uses BestellungAuftrag::setAuftragsart()
     * @uses BestellungAuftrag::setAuftragskennung()
     * @uses BestellungAuftrag::setAuftragsSupportID()
     * @uses BestellungAuftrag::setPositionen()
     * @uses BestellungAuftrag::setGebindeId()
     * @param string $id
     * @param string $auftragsart
     * @param string $auftragskennung
     * @param int $auftragsSupportID
     * @param \StructType\BestellungPosition[] $positionen
     * @param string $gebindeId
     */
    public function __construct($id = null, $auftragsart = null, $auftragskennung = null, $auftragsSupportID = null, array $positionen = array(), $gebindeId = null)
    {
        $this
            ->setId($id)
            ->setAuftragsart($auftragsart)
            ->setAuftragskennung($auftragskennung)
            ->setAuftragsSupportID($auftragsSupportID)
            ->setPositionen($positionen)
            ->setGebindeId($gebindeId);
    }
    /**
     * Get Id value
     * @return string
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\BestellungAuftrag
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Auftragsart value
     * @return string
     */
    public function getAuftragsart()
    {
        return $this->Auftragsart;
    }
    /**
     * Set Auftragsart value
     * @uses \EnumType\Auftragsart::valueIsValid()
     * @uses \EnumType\Auftragsart::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $auftragsart
     * @return \StructType\BestellungAuftrag
     */
    public function setAuftragsart($auftragsart = null)
    {
        $this->Auftragsart = $auftragsart;
        return $this;
    }
    /**
     * Get Auftragskennung value
     * @return string
     */
    public function getAuftragskennung()
    {
        return $this->Auftragskennung;
    }
    /**
     * Set Auftragskennung value
     * @param string $auftragskennung
     * @return \StructType\BestellungAuftrag
     */
    public function setAuftragskennung($auftragskennung = null)
    {
        $this->Auftragskennung = $auftragskennung;
        return $this;
    }
    /**
     * Get AuftragsSupportID value
     * @return int
     */
    public function getAuftragsSupportID()
    {
        return $this->AuftragsSupportID;
    }
    /**
     * Set AuftragsSupportID value
     * @param int $auftragsSupportID
     * @return \StructType\BestellungAuftrag
     */
    public function setAuftragsSupportID($auftragsSupportID = null)
    {
        $this->AuftragsSupportID = $auftragsSupportID;
        return $this;
    }
    /**
     * Get Positionen value
     * @return \StructType\BestellungPosition[]|null
     */
    public function getPositionen()
    {
        return $this->Positionen;
    }
    /**
     * Set Positionen value
     * @throws \InvalidArgumentException
     * @param \StructType\BestellungPosition[] $positionen
     * @return \StructType\BestellungAuftrag
     */
    public function setPositionen(array $positionen = array())
    {
        $this->Positionen = $positionen;
        return $this;
    }
    /**
     * Add item to Positionen value
     * @throws \InvalidArgumentException
     * @param \StructType\BestellungPosition $item
     * @return \StructType\BestellungAuftrag
     */
    public function addToPositionen(\StructType\BestellungPosition $item)
    {
        $this->Positionen[] = $item;
        return $this;
    }
    /**
     * Get GebindeId value
     * @return string|null
     */
    public function getGebindeId()
    {
        return $this->GebindeId;
    }
    /**
     * Set GebindeId value
     * @param string $gebindeId
     * @return \StructType\BestellungAuftrag
     */
    public function setGebindeId($gebindeId = null)
    {
        $this->GebindeId = $gebindeId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BestellungAuftrag
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
