<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BestellungAntwortAuftrag StructType
 * Meta informations extracted from the WSDL
 * - documentation: Fachlich ist das ein Choice aber wegen technichen Problement im .NET Generator, steht hier eine Sequence. Es wird aber fachlich zur Laufzeit validiert, dass entweder ein oder das andere Element vorhanden ist.
 * @subpackage Structs
 */
class BestellungAntwortAuftrag extends AbstractStructBase
{
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - use: required
     * - documentation: eindeutige sich nie wiederholende ID des Webservicerequests. (Fuer Benutzung bei AF2 - Nachtraegliche Antwortabfrage fuer eine Bestellung) Datentyp GUID (Primaerschluessel)
     * - length: 36
     * - pattern: ([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}
     * @var string
     */
    public $Id;
    /**
     * The Auftragsart
     * Meta informations extracted from the WSDL
     * - documentation: Die Augtragsart muss immer der Anfrage-Auftragsart entsprechen.
     * - use: required
     * @var string
     */
    public $Auftragsart;
    /**
     * The Auftragskennung
     * Meta informations extracted from the WSDL
     * - documentation: Eine von 4 vordefinierten oder eine freie kennung. Kann von der Anfrage-Kennung abweichen und durch einer der 4 vordefinierten Kennungen ersetzt werden (Siehe Pflichtenheft). | Typ fuer alle auf Gebinden und Papier aufgedruckten
     * Kennungen
     * - use: required
     * - pattern: [A-Z0-9+\-_]{1,20}
     * @var string
     */
    public $Auftragskennung;
    /**
     * The AuftragsSupportID
     * Meta informations extracted from the WSDL
     * - documentation: ausschliessliche Identifikation fuer Menschen! Support (optional Anzeige auf GUI kein Andruck) - keine technische Semantik Apo-Wawi vergibt diese; soll genuegend Selektiv sein
     * - use: required
     * - maxInclusive: 999999
     * - minInclusive: 1
     * @var int
     */
    public $AuftragsSupportID;
    /**
     * The Positionen
     * Meta informations extracted from the WSDL
     * - documentation: Reihenfolge in der Antwort kann von der Anfrage abweichen! keine doppelten PZNs innerhalb eines Auftrags erlaubt (in gesamter Bestellung schon). Wenn Auftragsfehler gesetzt ist, ist Anzahl der Positionen immer 0.
     * - maxOccurs: 1000
     * - minOccurs: 0
     * @var \StructType\BestellungAntwortPosition[]
     */
    public $Positionen;
    /**
     * The Auftragsfehler
     * Meta informations extracted from the WSDL
     * - documentation: Wenn gesetzt ist, darf der Auftrag keine Positionen enthalten.
     * - minOccurs: 0
     * @var \StructType\Msv3FaultInfo
     */
    public $Auftragsfehler;
    /**
     * The GebindeId
     * Meta informations extracted from the WSDL
     * - documentation: bei Auftragsart=Versand Pflicht sonst nicht erlaubt | Typ fuer alle auf Gebinden und Papier aufgedruckten Kennungen
     * - use: optional
     * - pattern: [A-Z0-9+\-_]{1,20}
     * @var string
     */
    public $GebindeId;
    /**
     * Constructor method for BestellungAntwortAuftrag
     * @uses BestellungAntwortAuftrag::setId()
     * @uses BestellungAntwortAuftrag::setAuftragsart()
     * @uses BestellungAntwortAuftrag::setAuftragskennung()
     * @uses BestellungAntwortAuftrag::setAuftragsSupportID()
     * @uses BestellungAntwortAuftrag::setPositionen()
     * @uses BestellungAntwortAuftrag::setAuftragsfehler()
     * @uses BestellungAntwortAuftrag::setGebindeId()
     * @param string $id
     * @param string $auftragsart
     * @param string $auftragskennung
     * @param int $auftragsSupportID
     * @param \StructType\BestellungAntwortPosition[] $positionen
     * @param \StructType\Msv3FaultInfo $auftragsfehler
     * @param string $gebindeId
     */
    public function __construct($id = null, $auftragsart = null, $auftragskennung = null, $auftragsSupportID = null, array $positionen = array(), \StructType\Msv3FaultInfo $auftragsfehler = null, $gebindeId = null)
    {
        $this
            ->setId($id)
            ->setAuftragsart($auftragsart)
            ->setAuftragskennung($auftragskennung)
            ->setAuftragsSupportID($auftragsSupportID)
            ->setPositionen($positionen)
            ->setAuftragsfehler($auftragsfehler)
            ->setGebindeId($gebindeId);
    }
    /**
     * Get Id value
     * @return string
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\BestellungAntwortAuftrag
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Auftragsart value
     * @return string
     */
    public function getAuftragsart()
    {
        return $this->Auftragsart;
    }
    /**
     * Set Auftragsart value
     * @uses \EnumType\Auftragsart::valueIsValid()
     * @uses \EnumType\Auftragsart::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $auftragsart
     * @return \StructType\BestellungAntwortAuftrag
     */
    public function setAuftragsart($auftragsart = null)
    {
        $this->Auftragsart = $auftragsart;
        return $this;
    }
    /**
     * Get Auftragskennung value
     * @return string
     */
    public function getAuftragskennung()
    {
        return $this->Auftragskennung;
    }
    /**
     * Set Auftragskennung value
     * @param string $auftragskennung
     * @return \StructType\BestellungAntwortAuftrag
     */
    public function setAuftragskennung($auftragskennung = null)
    {
        $this->Auftragskennung = $auftragskennung;
        return $this;
    }
    /**
     * Get AuftragsSupportID value
     * @return int
     */
    public function getAuftragsSupportID()
    {
        return $this->AuftragsSupportID;
    }
    /**
     * Set AuftragsSupportID value
     * @param int $auftragsSupportID
     * @return \StructType\BestellungAntwortAuftrag
     */
    public function setAuftragsSupportID($auftragsSupportID = null)
    {
        $this->AuftragsSupportID = $auftragsSupportID;
        return $this;
    }
    /**
     * Get Positionen value
     * @return \StructType\BestellungAntwortPosition[]|null
     */
    public function getPositionen()
    {
        return $this->Positionen;
    }
    /**
     * Set Positionen value
     * @throws \InvalidArgumentException
     * @param \StructType\BestellungAntwortPosition[] $positionen
     * @return \StructType\BestellungAntwortAuftrag
     */
    public function setPositionen(array $positionen = array())
    {
        $this->Positionen = $positionen;
        return $this;
    }
    /**
     * Add item to Positionen value
     * @throws \InvalidArgumentException
     * @param \StructType\BestellungAntwortPosition $item
     * @return \StructType\BestellungAntwortAuftrag
     */
    public function addToPositionen(\StructType\BestellungAntwortPosition $item)
    {
        $this->Positionen[] = $item;
        return $this;
    }
    /**
     * Get Auftragsfehler value
     * @return \StructType\Msv3FaultInfo|null
     */
    public function getAuftragsfehler()
    {
        return $this->Auftragsfehler;
    }
    /**
     * Set Auftragsfehler value
     * @param \StructType\Msv3FaultInfo $auftragsfehler
     * @return \StructType\BestellungAntwortAuftrag
     */
    public function setAuftragsfehler(\StructType\Msv3FaultInfo $auftragsfehler = null)
    {
        $this->Auftragsfehler = $auftragsfehler;
        return $this;
    }
    /**
     * Get GebindeId value
     * @return string|null
     */
    public function getGebindeId()
    {
        return $this->GebindeId;
    }
    /**
     * Set GebindeId value
     * @param string $gebindeId
     * @return \StructType\BestellungAntwortAuftrag
     */
    public function setGebindeId($gebindeId = null)
    {
        $this->GebindeId = $gebindeId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BestellungAntwortAuftrag
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
