<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Bestellung StructType
 * Meta informations extracted from the WSDL
 * - documentation: nur die fachliche Anfrage Die Struktur (Auftraege und Positionen) bezueglich Mengen und Reihenfolgen muss zwischen Anfrage und Antwort identisch sein
 * @subpackage Structs
 */
class Bestellung extends AbstractStructBase
{
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - use: required
     * - documentation: eindeutige sich nie wiederholende ID des Webservicerequests. (Fuer Benutzung bei AF2 - Nachtraegliche Antwortabfrage fuer eine Bestellung) Datentyp GUID (Primaerschluessel)
     * - length: 36
     * - pattern: ([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}
     * @var string
     */
    public $Id;
    /**
     * The BestellSupportId
     * Meta informations extracted from the WSDL
     * - documentation: ausschliessliche Identifikation fuer Menschen! Support (optional Anzeige auf GUI kein Andruck) - keine technische Semantik Apo-Wawi vergibt diese; soll genuegend Selektiv sein
     * - use: required
     * - maxInclusive: 999999
     * - minInclusive: 1
     * @var int
     */
    public $BestellSupportId;
    /**
     * The Auftraege
     * Meta informations extracted from the WSDL
     * - documentation: Reihenfolge in der Antwort darf beliebig sein! aber maximal 1000 Positionen in der gesamten Bestellung!
     * - maxOccurs: 1000
     * @var \StructType\BestellungAuftrag[]
     */
    public $Auftraege;
    /**
     * Constructor method for Bestellung
     * @uses Bestellung::setId()
     * @uses Bestellung::setBestellSupportId()
     * @uses Bestellung::setAuftraege()
     * @param string $id
     * @param int $bestellSupportId
     * @param \StructType\BestellungAuftrag[] $auftraege
     */
    public function __construct($id = null, $bestellSupportId = null, array $auftraege = array())
    {
        $this
            ->setId($id)
            ->setBestellSupportId($bestellSupportId)
            ->setAuftraege($auftraege);
    }
    /**
     * Get Id value
     * @return string
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\Bestellung
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Get BestellSupportId value
     * @return int
     */
    public function getBestellSupportId()
    {
        return $this->BestellSupportId;
    }
    /**
     * Set BestellSupportId value
     * @param int $bestellSupportId
     * @return \StructType\Bestellung
     */
    public function setBestellSupportId($bestellSupportId = null)
    {
        $this->BestellSupportId = $bestellSupportId;
        return $this;
    }
    /**
     * Get Auftraege value
     * @return \StructType\BestellungAuftrag[]|null
     */
    public function getAuftraege()
    {
        return $this->Auftraege;
    }
    /**
     * Set Auftraege value
     * @throws \InvalidArgumentException
     * @param \StructType\BestellungAuftrag[] $auftraege
     * @return \StructType\Bestellung
     */
    public function setAuftraege(array $auftraege = array())
    {
        $this->Auftraege = $auftraege;
        return $this;
    }
    /**
     * Add item to Auftraege value
     * @throws \InvalidArgumentException
     * @param \StructType\BestellungAuftrag $item
     * @return \StructType\Bestellung
     */
    public function addToAuftraege(\StructType\BestellungAuftrag $item)
    {
        $this->Auftraege[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Bestellung
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
