<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BestellstatusAntwort StructType
 * Meta informations extracted from the WSDL
 * - documentation: gibt an, ob: - Bestellkennung unbekannt ist (seit 7 Tagen) - Bestellkennung bekannt, aber Bestellantwort ist NICHT MEHR verfuegbar - Bestellkennung bekannt, Bestellantwort ist verfuegbar
 * @subpackage Structs
 */
class BestellstatusAntwort extends AbstractStructBase
{
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Kennung der angefragten Bestellung | eindeutige sich nie wiederholende ID des Webservicerequests. (Fuer Benutzung bei AF2 - Nachtraegliche Antwortabfrage fuer eine Bestellung) Datentyp GUID (Primaerschluessel)
     * - use: required
     * - length: 36
     * - pattern: ([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}
     * @var string
     */
    public $Id;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Status;
    /**
     * The BestellSupportId
     * Meta informations extracted from the WSDL
     * - documentation: ausschliessliche Identifikation fuer Menschen! Support (optional Anzeige auf GUI kein Andruck) - keine technische Semantik Apo-Wawi vergibt diese; soll genuegend Selektiv sein
     * - nillable: true
     * - maxInclusive: 999999
     * - minInclusive: 1
     * @var int
     */
    public $BestellSupportId;
    /**
     * The Auftraege
     * Meta informations extracted from the WSDL
     * - documentation: Die Reihenfolge der Auftraege in der Antwort darf von der Abfrage-Reihenfolge abweichen. Die Anzahl der Elemente muss identisch sein. Auftraege sind nur beim Status = BestellungAntwortVerfuegbar gesetzt
     * - maxOccurs: 1000
     * - minOccurs: 0
     * @var \StructType\BestellungAntwortAuftrag[]
     */
    public $Auftraege;
    /**
     * Constructor method for BestellstatusAntwort
     * @uses BestellstatusAntwort::setId()
     * @uses BestellstatusAntwort::setStatus()
     * @uses BestellstatusAntwort::setBestellSupportId()
     * @uses BestellstatusAntwort::setAuftraege()
     * @param string $id
     * @param string $status
     * @param int $bestellSupportId
     * @param \StructType\BestellungAntwortAuftrag[] $auftraege
     */
    public function __construct($id = null, $status = null, $bestellSupportId = null, array $auftraege = array())
    {
        $this
            ->setId($id)
            ->setStatus($status)
            ->setBestellSupportId($bestellSupportId)
            ->setAuftraege($auftraege);
    }
    /**
     * Get Id value
     * @return string
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\BestellstatusAntwort
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\Bestellstatus::valueIsValid()
     * @uses \EnumType\Bestellstatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\BestellstatusAntwort
     */
    public function setStatus($status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get BestellSupportId value
     * @return int|null
     */
    public function getBestellSupportId()
    {
        return $this->BestellSupportId;
    }
    /**
     * Set BestellSupportId value
     * @param int $bestellSupportId
     * @return \StructType\BestellstatusAntwort
     */
    public function setBestellSupportId($bestellSupportId = null)
    {
        $this->BestellSupportId = $bestellSupportId;
        return $this;
    }
    /**
     * Get Auftraege value
     * @return \StructType\BestellungAntwortAuftrag[]|null
     */
    public function getAuftraege()
    {
        return $this->Auftraege;
    }
    /**
     * Set Auftraege value
     * @throws \InvalidArgumentException
     * @param \StructType\BestellungAntwortAuftrag[] $auftraege
     * @return \StructType\BestellstatusAntwort
     */
    public function setAuftraege(array $auftraege = array())
    {
        $this->Auftraege = $auftraege;
        return $this;
    }
    /**
     * Add item to Auftraege value
     * @throws \InvalidArgumentException
     * @param \StructType\BestellungAntwortAuftrag $item
     * @return \StructType\BestellstatusAntwort
     */
    public function addToAuftraege(\StructType\BestellungAntwortAuftrag $item)
    {
        $this->Auftraege[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BestellstatusAntwort
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
