<?php

namespace EnumType;

/**
 * This class stands for VerfuegbarkeitRueckmeldungTyp EnumType
 * @subpackage Enumerations
 */
class VerfuegbarkeitRueckmeldungTyp
{
    /**
     * Constant for value 'Normal'
     * @return string 'Normal'
     */
    const VALUE_NORMAL = 'Normal';
    /**
     * Constant for value 'Verbund'
     * @return string 'Verbund'
     */
    const VALUE_VERBUND = 'Verbund';
    /**
     * Constant for value 'Nachlieferung'
     * @return string 'Nachlieferung'
     */
    const VALUE_NACHLIEFERUNG = 'Nachlieferung';
    /**
     * Constant for value 'Dispo'
     * @return string 'Dispo'
     */
    const VALUE_DISPO = 'Dispo';
    /**
     * Constant for value 'NichtLieferbar'
     * @return string 'NichtLieferbar'
     */
    const VALUE_NICHT_LIEFERBAR = 'NichtLieferbar';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NORMAL
     * @uses self::VALUE_VERBUND
     * @uses self::VALUE_NACHLIEFERUNG
     * @uses self::VALUE_DISPO
     * @uses self::VALUE_NICHT_LIEFERBAR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NORMAL,
            self::VALUE_VERBUND,
            self::VALUE_NACHLIEFERUNG,
            self::VALUE_DISPO,
            self::VALUE_NICHT_LIEFERBAR,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
