<?php

namespace EnumType;

/**
 * This class stands for Substitutionsgrund EnumType
 * @subpackage Enumerations
 */
class Substitutionsgrund
{
    /**
     * Constant for value 'Nachfolgeprodukt'
     * @return string 'Nachfolgeprodukt'
     */
    const VALUE_NACHFOLGEPRODUKT = 'Nachfolgeprodukt';
    /**
     * Constant for value 'ReUndParallelImport'
     * @return string 'ReUndParallelImport'
     */
    const VALUE_RE_UND_PARALLEL_IMPORT = 'ReUndParallelImport';
    /**
     * Constant for value 'Vorschlag'
     * @return string 'Vorschlag'
     */
    const VALUE_VORSCHLAG = 'Vorschlag';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NACHFOLGEPRODUKT
     * @uses self::VALUE_RE_UND_PARALLEL_IMPORT
     * @uses self::VALUE_VORSCHLAG
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NACHFOLGEPRODUKT,
            self::VALUE_RE_UND_PARALLEL_IMPORT,
            self::VALUE_VORSCHLAG,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
